% This script tests Acc-MD method on three optimization problems:
% (1) Quartic Objectives
% (2) LASSO problem
% (3) Quadratic on Simplex 

addpath('baselines/smooth-convex/', 'baselines/composite/');
colors = [0 0.2 0.6;  
      0 0 0; 
      0.93 0.69 0.13; 
      0.502, 0.0, 0.502;   
      0.0, 0.392, 0.0]; 
rng(2);

%% Quartic Objectives
n = 256;
% data = data_quartic(n);
data = data_quartic_hard(n);
% disp([data.L,data.mu,data.L_relative,data.mu_relative]);
x0 = zeros(n,1); y0 = zeros(n,1);
max_iters = 10000; tol = 1e-6; StopCrit = 'GradNorm';
[soln, ~] = reference_optimizer(data, 100000, x0, 1e-10);
data.f_true = data.f(soln.x);
%% 
figure;
arf = AccMD(x0, y0, data, max_iters, tol, StopCrit);
semilogy(arf,'-o','Color',colors(1,:),'LineWidth',0.5,'MarkerSize',2);
hold on;
arf = NAMD(x0, y0, data,max_iters,tol, StopCrit);
semilogy(arf,'-o','Color',colors(2,:),'LineWidth',0.5,'MarkerSize',2);
hold on;
arf = NAG(x0, y0, data,max_iters,tol, StopCrit);
semilogy(arf,'-o','Color',colors(3,:),'LineWidth',0.5,'MarkerSize',2);
hold on;
arf = AORHB(x0, y0, data, max_iters, tol, StopCrit);
semilogy(arf,'-o','Color',colors(4,:),'LineWidth',0.5,'MarkerSize',2);
hold on;
arf = MD(x0, y0, data, max_iters, tol, StopCrit);
semilogy(arf,'-o','Color',colors(5,:),'LineWidth',0.5,'MarkerSize',2);
hold off;
xlim([1,2000]); ylim([1e-8,1]);
xlabel('Number of Steps','FontName','Times New Roman'); 
ylabel('$(f(x)-f(x^*))/(f(x_0)-f(x^*))$','Interpreter','latex','FontName','Times New Roman');
legend('Acc-MD','NAMD','NAG','AORHB','MD','Location','best','FontName','Times New Roman','Interpreter','latex'); grid on; 
