import numpy as np
from tqdm import tqdm


def partition_ppr_loader(prime_batchlist, neighbors, prime_indices):
    loader = []
    
    for primes in tqdm(prime_batchlist):
        secondary = set()
        mask = np.in1d(prime_indices, primes).nonzero()[0]
        for n in mask:
            secondary.update(neighbors[n])
        secondary = np.array(list(secondary), dtype=np.int64)
        
        loader.append((primes, secondary))
    
    return loader
            