import os
import numpy as np
import pandas as pd
import matplotlib.pyplot as plt    

def moving_average(seq, k):
    mv_seq = [np.mean(seq[max(0, i-k):(i+1)]) for i in range(len(seq))]
    return mv_seq

# rl results
# cwd = "/Users/hfml/Documents/Ran/rambo_tf_backup_results/rambo/best_run/"
# task = "halfcheetah-medium-expert-v2"
# file_path = os.path.join(cwd, task, "03-27-2023-00-44-00", "history.csv")

# cwd = "/Users/hfml/Documents/Ran/rambo_tf_backup_results/rambo/best_run/"
# task = "hopper-medium-expert-v2"
# file_path = os.path.join(cwd, task, "04-08-2023-15-55-10", "history.csv")

cwd = "/Users/hfml/Documents/Ran/rambo_tf_backup_results/rambo/failed_run/"
task = "hopper-medium-expert-v2"
file_path = os.path.join(cwd, task, "04-08-2023-01-36-59", "history.csv")

# cwd = "/Users/hfml/Documents/Ran/rambo_tf_backup_results/rambo/best_run/"
# task = "walker2d-medium-expert-v2"
# file_path = os.path.join(cwd, task, "03-27-2023-01-51-00", "history.csv")

# irl results
# cwd = "/Users/hfml/Documents/Ran/rambo_tf_backup_results/rail/"
# task = "halfcheetah-medium-expert-v2"
# file_path = os.path.join(cwd, task, "04-07-2023-21-34-44_traj", "history.csv")

# tuning checkpoints
cwd = "/Users/hfml/Documents/Ran/rambo/logs/rirl"
# task = "halfcheetah-medium-expert-v2"
task = "halfcheetah-medium-replay-v2"
# task = "hopper-medium-expert-v2"
# task = "walker2d-medium-expert-v2"
file_path = os.path.join(cwd, task, "04-24-2023-09-26-08", "history.csv")
                         
# rirl backup results
# cwd = "/Users/hfml/Documents/Ran/rambo_tf_backup_results/rirl"
# # task = "halfcheetah-medium-expert-v2"
# # task = "hopper-medium-expert-v2"
# # task = "hopper-medium-replay-v2"
# # task = "hopper-medium-v2"
# # task = "walker2d-medium-expert-v2"
# task = "walker2d-medium-v2"
# file_path = os.path.join(cwd, task, "04-19-2023-06-32-21", "history.csv")

# birl backup results
# cwd = "/Users/hfml/Documents/Ran/rambo_tf_backup_results/birl"
# # task = "halfcheetah-medium-expert-v2"
# # task = "walker2d-medium-expert-v2"
# task = "hopper-medium-expert-v2"
# file_path = os.path.join(cwd, task, "04-17-2023-09-31-29", "history.csv")

df = pd.read_csv(file_path)
reward = df["evaluation/return-average"].dropna().values

mean_reward = moving_average(reward, 1)

fig, ax = plt.subplots(1, 1, figsize=(6, 4))
ax.plot(mean_reward)
ax.set_title(task)

fig.savefig(file_path.replace(".csv", ".png"), dpi=100)
plt.show()