import tensorflow as tf

def test_tf_adam_optimizer(op="reduce_mean"):
    """ test tf default loss reduction: default is reduce_sum """
    print("\nop:", op)
    with tf.GradientTape() as g:
        x = tf.constant([1,2,3], dtype=tf.float32)
        k = tf.Variable(tf.constant([1,1,1], dtype=tf.float32))

        if op == "reduce_mean":
            loss = tf.reduce_mean(k * x)
        elif op == "reduce_sum":
            loss = tf.reduce_sum(k * x)
        else:
            loss = k * x
        optimizer = tf.train.AdamOptimizer(learning_rate=0.3)
        train_op = optimizer.minimize(
            loss,
            var_list=[k]
        )

    init = tf.global_variables_initializer()

    with tf.Session() as sess:
        sess.run(init)
        v = sess.run(k)
        print("before step", v)

        sess.run(train_op)

        v = sess.run(k)
        print("after step", v)

test_tf_adam_optimizer(op="")
test_tf_adam_optimizer(op="reduce_mean")
test_tf_adam_optimizer(op="reduce_sum")