# LEVERAGING ONLINE SEMANTIC POINT FUSION FOR 3D-AWARE OBJECT GOAL NAVIGATION]


## Installation

Our code is based on Python3.7 with the support of :

- Pytorch v1.10.0 with CUDA v11.3.
- [Habitat-lab](https://github.com/facebookresearch/habitat-lab) v2.2.0 : Library for embodied AI tasks. 
- [Habitat-sim](https://github.com/facebookresearch/habitat-sim) v2.2.0 : 3D simulator, core simulator for [Habitat-lab](https://github.com/facebookresearch/habitat-lab)
- [Detectron2]() : Library for detection and segmentation algorithms. 


```
cd GoalNavigation
pip install -r requirements.txt
```

Install other dependencies :

```
# Install Habitat-sim
git clone --branch stable https://github.com/facebookresearch/habitat-sim.git
cd habitat-sim
pip install -r requirements.txt; 
python setup.py install --headless
python setup.py install # (for Mac OS)

# Install Habitat-lab
git clone --branch stable https://github.com/facebookresearch/habitat-lab.git
cd habitat-lab; 
pip install -e .

# Install Pytorch of required version
pip install torch==1.10.1+cu111 torchvision==0.11.2+cu111 torchaudio==0.10.1 -f https://download.pytorch.org/whl/torch_stable.html

# Install Detectron2
python -m pip install detectron2==0.6 -f \\n  https://dl.fbaipublicfiles.com/detectron2/wheels/cu111/torch1.10/index.html
```


Our code has been tested on Ubuntu 18.04.


## Data Preparation

We train & test our model on different 3D scene datasets: [Gibson3D](http://gibsonenv.stanford.edu/database/), [Matterport3D (MP3D)](https://niessner.github.io/Matterport/) and [Habitat-Matterport3D (HM3D)](https://aihabitat.org/datasets/hm3d-semantics/). For object goal navigation task, the datasets are from Habitat Challenge [2021Nav](https://aihabitat.org/challenge/2021/) & [2022Nav](https://aihabitat.org/challenge/2022/)

Organize the dataset as below : 

````
data
  ├──── scene_datasets
  │ ├──── mp3d
  │ ├──── hm3d
  │ └──── (Gibson)
  ├──── objectnav_mp3d_v1
  ├──── objectnav_hm3d
  └──── (Gibson)
````

## Usage

Training the model : 
```
bash sh_train.sh
```

Testing the model : 
```
bash sh_eval.sh
```





