# Robotic Dog Guide

This dataset contains information about the human-robot interaction in the situation of a robotic dog guide. The information included is as follows: raw trajectory data, position and orientation of the robot over time, position and orientation of the human over time. All data was collected using the Vicon Evoke/Tracker Motion Capture System and Software, using active markers to track the position and orientation of the robot and the human subject.


## Data Information and Structure
There are 5 trajectories that we used to collect this dataset. They can be found in the paper (link to paper). Each trajectory was run 5 times, with the following description for each:
- Run 1: 
Trajectory is run normally, with a blindfold if the subject is not visually impaired.
- Run 2:
Trajectory is run normally, with a blindfold if the subject is not visually impaired.
- Run 3:
Trajectory is run normally, with a blindfold if the subject is not visually impaired.
- Run 4:
Trajectory is run with verbal cues from the researcher. The researcher informs the subject of the general routemap of the trajectory, followed by verbal cues before each change in movement (i.e. turn right, left, go forward, u-turn) before the robot makes the change.
- Run 5:
This trajectory is only applicable to those subjects that were not blind or visually impaired. In this trajectory, the subject is allowed to use their vision and physical sense (holding the harness) to follow the robotic dog guide. 


The structure of the data is as follows:
- Subject ID
  - 'ab.csv'
    - a: trajectory number
    - b: run number for that trajectory
    - contains data in the format described below
  - 'ab.png'
    - contains a visualization of the corresponding trajectory
  - 'ab_raw.csv'
    - contains the raw data of the corresponding trajectory


Within 'ab.csv', we have the following representation:
- Each Row: Timestep 0, 1, 2, 3, ...
- Each Column:
    - 'robot_x': X Coordinate of Robot at current timestep
    - 'robot_y': Y Coordinate of Robot at current timestep
    - 'robot_orientation': Orientation of Robot at current timestep (in radians)
    - 'robot_occlusion': If Robot is occluded at current timestep (True if occluded, False if not occluded)
    - 'human_x': X Coordinate of Human at current timestep
    - 'human_y': Y Coordinate of Human at current timestep
    - 'human_rotation': Orientation of Human at current timestep (in radians)
    - 'human_occlusion': If Human is occluded at current timestep (True if occluded, False if not occluded)

## Sample Visualizations
- Trajectory 1
![Sample Trajectory Visualization](sample_vis3.png)
- Trajectory 2
![Sample Trajectory Visualization](sample_vis2.png)
- Trajectory 3
![Sample Trajectory Visualization](sample_vis4.png)
- Trajectory 4
![Sample Trajectory Visualization](sample_vis1.png)
- Trajectory 5
![Sample Trajectory Visualization](sample_vis5.png)
