'''
record of all hyperparameters
'''

###################################################################################################
'''
synthetic data 
'''

synth1_hyperparams = \
{
    'baseline_plain_clean': {'l_rate': 0.001, 'l2': 0.01, 'batch': 5, 'n_layer': 2, 'layer_s': 100, \
                  'filter': False, 'fil_thr': 0.8, 'fil_opp': 0.9, 'transit': False, 'a1': 0.1, 'add_noise': False}, \
    'baseline_plain': {'l_rate': 0.001, 'l2': 0.01, 'batch': 5, 'n_layer': 2, 'layer_s': 100, \
                  'filter': False, 'fil_thr': 0.8, 'fil_opp': 0.9, 'transit': False, 'a1': 0.1, 'add_noise': False}, \
    'baseline_sln_filt': {'l_rate': 0.001, 'l2': 0.01, 'batch': 5, 'n_layer': 2, 'layer_s': 100, \
                  'filter': True, 'fil_thr': 90, 'fil_opp': 95, 'transit': False, 'a1': 0.1, 'add_noise': True}, \
    'baseline_transition': {'l_rate': 0.01, 'l2': 0.8, 'batch': 5, 'n_layer': 2, 'layer_s': 20, \
                  'fil_thr': 0.8, 'num_parts': 3, 'a1': 0.25, 'a2': 1}, \
    'baseline_transit_conf': {'l_rate': 0.01, 'l2': 0.8, 'batch': 5, 'n_layer': 2, 'layer_s': 20}, \
    'baseline_fair_gpl': {'l_rate': 0.001, 'l2': 0.01, 'batch': 5, 'n_layer': 2, 'layer_s': 100, \
                  'weight_lr': 0.001, 'a1': 0.1}, \
    'baseline_js_loss': {'l_rate': 0.001, 'l2': 0.01, 'batch': 5, 'n_layer': 2, 'layer_s': 100, 'pi': 0.5}, \
    'proposed1': {'l_rate': 0.002821181655865712, 'l2': 0.011839034735233178, 'batch': 5, 'n_layer': 2, 'layer_s': 100, \
                  'a1': 0.7738530472331953, 'b1': 1}, \
    'anchor': {'l_rate': 0.002821181655865712, 'l2': 0.011839034735233178, 'batch': 5, 'n_layer': 2, 'layer_s': 100, \
                  'a1': 0.7738530472331953, 'b1': 1}, \
}

synth1_rand_ranges = \
{
    'baseline_plain_clean': {'l_rate': [0.0001, 0.01], 'l2': [0.001, 0.1], 'batch': [5, 5], 'n_layer': [2, 2], 'layer_s': [100, 100], \
                  'filter': [False, False], 'fil_thr':[100, 100], 'fil_opp':[100, 100], 'add_noise': [False, False], 
                  'noise_amnt': [0.1, 0.1]}, \
    'baseline_plain': {'l_rate': [0.0001, 0.01], 'l2': [0.001, 0.1], 'batch': [5, 5], 'n_layer': [2, 2], 'layer_s': [100, 100], \
                  'filter': [False, False], 'fil_thr':[80, 80], 'fil_opp':[90, 90], 'add_noise': [False, False], \
                   'noise_amnt': [0.1, 0.1]}, \
    'baseline_sln_filt': {'l_rate': [0.0001, 0.01], 'l2': [0.001, 0.1], 'batch': [5, 5], 'n_layer': [2, 2], 'layer_s': [100, 100], \
                  'filter': [True, True], 'fil_thr':[60, 100], 'fil_opp':[100, 100], 'add_noise': [True, True], \
                   'noise_amnt': [0.001, 0.01]}, \
    'baseline_transition': {'l_rate': [0.0001, 0.01], 'l2': [0.001, 0.1], 'batch': [5, 5], 'n_layer': [2, 2], 'layer_s': [100, 100], \
                  'fil_thr':[50, 50], 'fil_thr2':[50, 50], 'num_parts': [1, 10], 'a1':[0.01, 10], 'a2':[0.01, 10], 'a3':[0.01, 10]}, \
    'baseline_transit_conf': {'l_rate': [0.0001, 0.01], 'l2': [0.001, 0.1], 'batch': [5, 5], 'n_layer': [2, 2], 'layer_s': [100, 100]},\
    'baseline_fair_gpl': {'l_rate': [0.0001, 0.01], 'l2': [0.001, 0.1], 'batch': [5, 5], 'n_layer': [2, 2], 'layer_s': [100, 100], \
                  'weight_lr': [0.0001, 0.0001], 'a1': [0.1, 1]}, \
    'baseline_js_loss': {'l_rate': [0.0001, 0.01], 'l2': [0.001, 0.01], 'batch': [5, 5], 'n_layer': [2, 2], 'layer_s': [100, 100], \
                  'pi':[0.01, 1]}, \
    'proposed1': {'l_rate': [0.0001, 0.01], 'l2': [0.01, 0.1], 'batch': [5, 5], 'n_layer': [2, 2], 'layer_s': [100, 100], \
                  'a1': [0.01, 10], 'b1':[0.01, 10], 'c1': [0.01, 10]}, \
}

synth1_ranges_f2 = \
{
    'baseline_plain_clean': {'l_rate': [0.0001, 0.01], 'l2': [0.001, 0.1], 'batch': [5, 5], 'n_layer': [2, 2], 'layer_s': [100, 100], \
                  'filter': [False, False], 'fil_thr':[100, 100], 'fil_opp':[100, 100], 'add_noise': [False, False], 
                  'noise_amnt': [0.1, 0.1]}, \
    'baseline_plain': {'l_rate': [0.0001, 0.01], 'l2': [0.001, 0.1], 'batch': [5, 5], 'n_layer': [2, 2], 'layer_s': [100, 100], \
                  'filter': [False, False], 'fil_thr':[80, 80], 'fil_opp':[90, 90], 'add_noise': [False, False], \
                   'noise_amnt': [0.1, 0.1]}, \
    'baseline_sln_filt': {'l_rate': [0.0001, 0.01], 'l2': [0.001, 0.1], 'batch': [5, 5], 'n_layer': [2, 2], 'layer_s': [100, 100], \
                  'filter': [True, True], 'fil_thr':[60, 90], 'fil_opp':[100, 100], 'add_noise': [True, True], \
                   'noise_amnt': [0.0001, 0.01]}, \
    'baseline_transition': {'l_rate': [0.0001, 0.01], 'l2': [0.001, 0.1], 'batch': [5, 5], 'n_layer': [2, 2], 'layer_s': [100, 100], \
                  'fil_thr':[50, 50], 'fil_thr2':[50, 50], 'num_parts': [1, 10], 'a1': [0.1, 10], 'a2': [0.1, 10], 'a3':[0.1, 10]}, \
    'baseline_transit_conf': {'l_rate': [0.0001, 0.1], 'l2': [0.001, 0.1], 'batch':[5, 5], 'n_layer': [2, 2], 'layer_s': [100, 100]},\
    'baseline_fair_gpl': {'l_rate': [0.0001, 0.01], 'l2': [0.001, 0.1], 'batch': [5, 5], 'n_layer': [2, 2], 'layer_s': [100, 100], \
                  'weight_lr': [0.0001, 0.0001], 'a1': [0.01, 0.1]}, \
    'baseline_js_loss': {'l_rate': [0.0001, 0.01], 'l2': [0.001, 0.1], 'batch': [5, 5], 'n_layer': [2, 2], 'layer_s': [100, 100], \
                  'pi':[0.001, 0.1]}, \
    'proposed1': {'l_rate': [0.0001, 0.01], 'l2': [0.001, 0.1], 'batch': [5, 5], 'n_layer': [2, 2], 'layer_s': [100, 100], \
                  'a1': [0.1, 10], 'b1':[0.1, 10], 'c1': [0.1, 10]}, \
} 


###################################################################################################
'''
mimic data 
'''
mimic_arf_hyperparams = \
{
    'baseline_plain_clean': {'l_rate': 0.001, 'l2': 0.01, 'batch': 5, 'n_layer': 2, 'layer_s': 100, \
                  'filter': False, 'fil_thr': 0.8, 'fil_opp': 0.9, 'transit': False, 'a1': 0.1, 'add_noise': False}, \
    'baseline_plain': {'l_rate': 0.001, 'l2': 0.01, 'batch': 5, 'n_layer': 2, 'layer_s': 100, \
                  'filter': False, 'fil_thr': 0.8, 'fil_opp': 0.9, 'transit': False, 'a1': 0.1, 'add_noise': False}, \
    'baseline_sln_filt': {'l_rate': 0.001, 'l2': 0.01, 'batch': 5, 'n_layer': 2, 'layer_s': 100, \
                  'filter': True, 'fil_thr': 90, 'fil_opp': 95, 'transit': False, 'a1': 0.1, 'add_noise': True}, \
    'baseline_transition': {'l_rate': 0.01, 'l2': 0.8, 'batch': 5, 'n_layer': 2, 'layer_s': 20, \
                  'fil_thr': 0.8, 'num_parts': 3, 'a1': 0.25, 'a2': 1}, \
    'baseline_transit_conf': {'l_rate': 0.01, 'l2': 0.8, 'batch': 5, 'n_layer': 2, 'layer_s': 20}, \
    'baseline_fair_gpl': {'l_rate': 0.001, 'l2': 0.01, 'batch': 5, 'n_layer': 2, 'layer_s': 100, \
                  'weight_lr': 0.001, 'a1': 0.1}, \
    'baseline_js_loss': {'l_rate': 0.001, 'l2': 0.01, 'batch': 5, 'n_layer': 2, 'layer_s': 100, 'pi': 0.5}, \
    'proposed1': {'l_rate': 0.001, 'l2': 0.01, 'batch': 5, 'n_layer': 2, 'layer_s': 100, \
                  'filter': True, 'fil_thr': 90, 'fil_opp': 95, 'a1': 1, 'b1': 1}, \
    'anchor': {'l_rate': 0.002821181655865712, 'l2': 0.011839034735233178, 'batch': 5, 'n_layer': 2, 'layer_s': 100, \
                  'a1': 0.7738530472331953, 'b1': 1}, \
} 


mimic_arf_ranges_rand = \
{
    'baseline_plain_clean': {'l_rate':[0.00001, 0.001], 'l2':[0.000001, 0.01], 'batch':[5, 5], 'n_layer':[2, 2], 'layer_s':[500, 500], \
                  'filter': [False, False], 'fil_thr':[100, 100], 'fil_opp':[100, 100], 'a1': [1, 1], 'add_noise': [False, False], \
                   'noise_amnt': [0.1, 0.1]}, \
    'baseline_plain': {'l_rate':[0.001, 0.01], 'l2':[0.000001, 0.01], 'batch':[5, 5], 'n_layer':[2, 2], 'layer_s':[500, 500], \
                  'filter': [False, False], 'fil_thr':[80, 80], 'fil_opp':[90, 90], 'a1': [1, 1], 'add_noise': [False, False], \
                   'noise_amnt': [0.1, 0.1]}, \
    'baseline_sln_filt': {'l_rate':[0.00001, 0.001], 'l2':[0.000001, 0.01], 'batch':[5, 5], 'n_layer':[2, 2], 'layer_s':[500, 500], \
                  'filter': [True, True], 'fil_thr':[50, 90], 'fil_opp':[100, 100], 'a1': [0.1, 0.10], 'add_noise': [True, True], \
                   'noise_amnt': [0.00001, 0.001]}, \
    'baseline_transition': {'l_rate':[0.00001, 0.001], 'l2':[0.000001, 0.1], 'batch':[5, 5], 'n_layer':[2, 2], 'layer_s':[500, 500], \
                  'fil_thr':[50, 50], 'fil_thr2':[100, 100], 'num_parts': [1, 10], 'a1':[0.1, 10], 'a2':[0.1, 10], 'a3':[0.1, 10]}, \
    'baseline_transit_conf': {'l_rate':[0.00001, 0.001], 'l2':[0.00001, 0.01], 'batch':[5, 5], 'n_layer':[2, 2],'layer_s':[500, 500]},\
    'baseline_fair_gpl': {'l_rate':[0.00001, 0.001], 'l2':[0.000001, 0.01], 'batch':[5, 5], 'n_layer':[2, 2], 'layer_s':[500, 500], \
                  'weight_lr': [0.0001, 0.0001], 'a1': [0.1, 1]}, \
    'baseline_js_loss': {'l_rate':[0.00001, 0.001], 'l2':[0.0000001, 0.01], 'batch':[5, 5], 'n_layer':[2, 2], 'layer_s':[500, 500], \
                  'pi':[0.01, 0.1]}, \
    'proposed1': {'l_rate':[0.00001, 0.001], 'l2':[0.00001, 0.1], 'batch':[5, 5], 'n_layer':[2, 2], 'layer_s':[500, 500], \
                  'a1': [0.1, 10], 'b1':[0.1, 10], 'c1': [0.1, 10]}, \
}


mimic_arf_ranges_f2 = \
{
    'baseline_plain_clean': {'l_rate':[0.00001, 0.001], 'l2':[0.000001, 0.01], 'batch':[5, 5], 'n_layer':[2, 2], 'layer_s':[500, 500], \
                  'filter': [False, False], 'fil_thr':[100, 100], 'fil_opp':[100, 100], 'a1': [1, 1], 'add_noise': [False, False], \
                   'noise_amnt': [0.1, 0.1]}, \
    'baseline_plain': {'l_rate':[0.00001, 0.001], 'l2':[0.00001, 0.01], 'batch':[5, 5], 'n_layer':[2, 2], 'layer_s':[500, 500], \
                  'filter': [False, False], 'fil_thr':[80, 80], 'fil_opp':[90, 90], 'a1': [1, 1], 'add_noise': [False, False], \
                   'noise_amnt': [0.1, 0.1]}, \
    'baseline_sln_filt': {'l_rate':[0.00001, 0.001], 'l2':[0.000001, 0.01], 'batch':[5, 5], 'n_layer':[2, 2], 'layer_s':[500, 500], \
                  'filter': [True, True], 'fil_thr':[50, 90], 'fil_opp':[100, 100], 'a1': [0.1, 0.10], 'add_noise': [True, True], \
                   'noise_amnt': [0.00001, 0.001]}, \
    'baseline_transition': {'l_rate':[0.00001, 0.001], 'l2':[0.000001, 0.01], 'batch':[5, 5], 'n_layer':[2, 2], 'layer_s':[500, 500], \
                  'fil_thr':[50, 50], 'fil_thr2':[100, 100], 'num_parts': [1, 10], 'a1':[0.1, 10], 'a2':[0.1, 10], 'a3':[0.1, 10]}, \
    'baseline_transit_conf': {'l_rate':[0.0001, 0.001], 'l2':[0.000001, 0.01], 'batch':[5, 5], 'n_layer':[2, 2],'layer_s':[500, 500]},\
    'baseline_fair_gpl': {'l_rate':[0.00001, 0.001], 'l2':[0.000001, 0.01], 'batch':[5, 5], 'n_layer':[2, 2], 'layer_s':[500, 500], \
                  'weight_lr': [0.0001, 0.0001], 'a1': [0.001, 0.1]}, \
    'baseline_js_loss': {'l_rate':[0.00001, 0.001], 'l2':[0.00001, 0.01], 'batch':[5, 5], 'n_layer':[2, 2], 'layer_s':[500, 500], \
                  'pi':[0.01, 0.1]}, \
    'proposed1': {'l_rate':[0.00001, 0.001], 'l2':[0.000001, 0.01], 'batch':[5, 5], 'n_layer':[2, 2], 'layer_s':[500, 500], \
                  'a1': [0.1, 10], 'b1':[0.1, 10], 'c1': [0.1, 10]}, \
}


mimic_shock_hyperparams = \
{
    'baseline_plain_clean': {'l_rate': 0.001, 'l2': 0.01, 'batch': 5, 'n_layer': 2, 'layer_s': 100, \
                  'filter': False, 'fil_thr': 0.8, 'fil_opp': 0.9, 'transit': False, 'a1': 0.1, 'add_noise': False}, \
    'baseline_plain': {'l_rate': 0.001, 'l2': 0.01, 'batch': 5, 'n_layer': 2, 'layer_s': 100, \
                  'filter': False, 'fil_thr': 0.8, 'fil_opp': 0.9, 'transit': False, 'a1': 0.1, 'add_noise': False}, \
    'baseline_sln_filt': {'l_rate': 0.001, 'l2': 0.01, 'batch': 5, 'n_layer': 2, 'layer_s': 100, \
                  'filter': True, 'fil_thr': 90, 'fil_opp': 95, 'transit': False, 'a1': 0.1, 'add_noise': True}, \
    'baseline_transition': {'l_rate': 0.01, 'l2': 0.8, 'batch': 5, 'n_layer': 2, 'layer_s': 20, \
                  'fil_thr': 0.8, 'num_parts': 3, 'a1': 0.25, 'a2': 1}, \
    'baseline_transit_conf': {'l_rate': 0.01, 'l2': 0.8, 'batch': 5, 'n_layer': 2, 'layer_s': 20}, \
    'baseline_fair_gpl': {'l_rate': 0.001, 'l2': 0.01, 'batch': 5, 'n_layer': 2, 'layer_s': 100, \
                  'weight_lr': 0.001, 'a1': 0.1}, \
    'baseline_js_loss': {'l_rate': 0.001, 'l2': 0.01, 'batch': 5, 'n_layer': 2, 'layer_s': 100, 'pi': 0.5}, \
    'proposed1': {'l_rate': 0.001, 'l2': 0.01, 'batch': 5, 'n_layer': 2, 'layer_s': 100, \
                  'filter': True, 'fil_thr': 90, 'fil_opp': 95, 'a1': 1, 'b1': 1}, \
    'anchor': {'l_rate': 0.002821181655865712, 'l2': 0.011839034735233178, 'batch': 5, 'n_layer': 2, 'layer_s': 100, \
                  'a1': 0.7738530472331953, 'b1': 1}, \
} 

mimic_shock_ranges_rand = \
{
    'baseline_plain_clean': {'l_rate':[0.00001, 0.001], 'l2':[0.000001, 0.01], 'batch':[5, 5], 'n_layer':[2, 2], 'layer_s':[500, 500], \
                  'filter': [False, False], 'fil_thr':[100, 100], 'fil_opp':[100, 100], 'a1': [1, 1], 'add_noise': [False, False], \
                   'noise_amnt': [0.1, 0.1]}, \
    'baseline_plain': {'l_rate':[0.00001, 0.001], 'l2':[0.000001, 0.01], 'batch':[5, 5], 'n_layer':[2, 2], 'layer_s':[500, 500], \
                  'filter': [False, False], 'fil_thr':[80, 80], 'fil_opp':[90, 90], 'a1': [1, 1], 'add_noise': [False, False], \
                   'noise_amnt': [0.1, 0.1]}, \
    'baseline_sln_filt': {'l_rate':[0.00001, 0.001], 'l2':[0.000001, 0.01], 'batch':[5, 5], 'n_layer':[2, 2], 'layer_s':[500, 500], \
                  'filter': [True, True], 'fil_thr':[50, 90], 'fil_opp':[100, 100], 'a1': [0.1, 0.10], 'add_noise': [True, True], \
                   'noise_amnt': [0.0001, 0.01]}, \
    'baseline_transition': {'l_rate':[0.00001, 0.001], 'l2':[0.000001, 0.01], 'batch':[5, 5], 'n_layer':[2, 2], 'layer_s':[500, 500], \
                  'fil_thr':[50, 50], 'fil_thr2':[100, 100], 'num_parts': [1, 10], 'a1': [0.1, 10], 'a2':[0.1, 10], 'a3':[0.1, 10]}, \
    'baseline_transit_conf': {'l_rate':[0.00001, 0.001], 'l2':[0.00001, 0.01], 'batch':[5, 5], 'n_layer':[2, 2],'layer_s':[500, 500]},\
    'baseline_fair_gpl': {'l_rate':[0.00001, 0.001], 'l2':[0.000001, 0.01], 'batch':[5, 5], 'n_layer':[2, 2], 'layer_s':[500, 500], \
                  'weight_lr': [0.0001, 0.0001], 'a1': [0.01, 1]}, \
    'baseline_js_loss': {'l_rate':[0.00001, 0.001], 'l2':[0.000001, 0.01], 'batch':[5, 5], 'n_layer':[2, 2], 'layer_s':[500, 500], \
                  'pi':[0.0001, 0.1]}, \
    'proposed1': {'l_rate':[0.00001, 0.001], 'l2':[0.000001, 0.01], 'batch':[5, 5], 'n_layer':[2, 2], 'layer_s':[500, 500], \
                  'a1': [0.1, 10], 'b1':[0.1, 10], 'c1': [0.1, 10]}, \
}

mimic_shock_ranges_f2 = \
{
    'baseline_plain_clean': {'l_rate':[0.000001, 0.0001],'l2':[0.000001, 0.01],'batch':[5, 5], 'n_layer':[2, 2], 'layer_s':[500, 500], \
                  'filter': [False, False], 'fil_thr':[100, 100], 'fil_opp':[100, 100], 'a1': [1, 1], 'add_noise': [False, False], \
                   'noise_amnt': [0.1, 0.1]}, \
    'baseline_plain': {'l_rate':[0.00001, 0.001], 'l2':[0.00001, 0.01], 'batch':[5, 5], 'n_layer':[2, 2], 'layer_s':[500, 500], \
                  'filter': [False, False], 'fil_thr':[80, 80], 'fil_opp':[90, 90], 'a1': [1, 1], 'add_noise': [False, False], \
                   'noise_amnt': [0.1, 0.1]}, \
    'baseline_sln_filt': {'l_rate':[0.00001, 0.001], 'l2':[0.0001, 0.01], 'batch':[5, 5], 'n_layer':[2, 2], 'layer_s':[500, 500], \
                  'filter': [True, True], 'fil_thr':[50, 90], 'fil_opp':[100, 100], 'a1': [0.1, 0.10], 'add_noise': [True, True], \
                   'noise_amnt': [0.00001, 0.001]}, \
    'baseline_transition': {'l_rate':[0.00001, 0.001], 'l2':[0.0000001, 0.01], 'batch':[5, 5], 'n_layer':[2, 2], 'layer_s':[500, 500], \
                  'fil_thr':[50, 50],'fil_thr2':[100, 100],'num_parts':[1, 10], 'a1':[0.1, 10], 'a2':[0.1, 10], 'a3':[0.1, 10]}, \
    'baseline_transit_conf': {'l_rate':[0.00001, 0.001], 'l2':[0.000001, 0.01], 'batch':[5, 5], 'n_layer':[2, 2],'layer_s':[500, 500]},\
    'baseline_fair_gpl': {'l_rate':[0.00001, 0.01], 'l2':[0.00001, 0.01], 'batch':[5, 5], 'n_layer':[2, 2], 'layer_s':[500, 500], \
                  'weight_lr': [0.0001, 0.0001], 'a1': [0.001, 0.01]}, \
    'baseline_js_loss': {'l_rate':[0.0001, 0.001], 'l2':[0.000001, 0.01], 'batch':[5, 5], 'n_layer':[2, 2], 'layer_s':[500, 500], \
                  'pi':[0.001, 0.1]}, \
    'proposed1': {'l_rate':[0.00001, 0.001], 'l2':[0.000001, 0.01], 'batch':[5, 5], 'n_layer':[2, 2], 'layer_s':[500, 500], \
                 'a1': [0.01, 10], 'b1':[0.01, 10], 'c1': [0.01, 10]}, \
    #'proposed1': {'l_rate':[0.00001, 0.001], 'l2':[0.000001, 0.01], 'batch':[5, 5], 'n_layer':[2, 2], 'layer_s':[500, 500], \
    #             'a1': [0.01, 10], 'b1':[0.01, 10], 'c1': [0.01, 10]}, \
    #'proposed1': {'l_rate':[0.00001, 0.001], 'l2':[0.00001, 0.01], 'batch':[5, 5], 'n_layer':[2, 2], 'layer_s':[500, 500], \
    #             'a1': [0.01, 10], 'b1':[0.01, 10], 'c1': [0.01, 10]}, \
}

###################################################################################################
'''
adult dataset from fairness literature
'''
adult_hyperparams = \
{
    'baseline_plain_clean': {'l_rate': 0.001, 'l2': 0.01, 'batch': 5, 'n_layer': 2, 'layer_s': 100, \
                  'filter': False, 'fil_thr': 0.8, 'fil_opp': 0.9, 'transit': False, 'a1': 0.1, 'add_noise': False}, \
    'baseline_plain': {'l_rate': 0.001, 'l2': 0.01, 'batch': 5, 'n_layer': 2, 'layer_s': 100, \
                  'filter': False, 'fil_thr': 0.8, 'fil_opp': 0.9, 'transit': False, 'a1': 0.1, 'add_noise': False}, \
    'baseline_sln_filt': {'l_rate': 0.001, 'l2': 0.01, 'batch': 5, 'n_layer': 2, 'layer_s': 100, \
                  'filter': True, 'fil_thr': 90, 'fil_opp': 95, 'transit': False, 'a1': 0.1, 'add_noise': True}, \
    'baseline_transition': {'l_rate': 0.01, 'l2': 0.8, 'batch': 5, 'n_layer': 2, 'layer_s': 20, \
                  'fil_thr': 0.8, 'num_parts': 3, 'a1': 0.25, 'a2': 1}, \
    'baseline_transit_conf': {'l_rate': 0.01, 'l2': 0.8, 'batch': 5, 'n_layer': 2, 'layer_s': 20}, \
    'baseline_fair_gpl': {'l_rate': 0.001, 'l2': 0.01, 'batch': 5, 'n_layer': 2, 'layer_s': 100, \
                  'weight_lr': 0.001, 'a1': 0.1}, \
    'baseline_js_loss': {'l_rate': 0.001, 'l2': 0.01, 'batch': 5, 'n_layer': 2, 'layer_s': 100, 'pi': 0.5}, \
    'proposed1': {'l_rate': 0.001, 'l2': 0.01, 'batch': 5, 'n_layer': 2, 'layer_s': 100, \
                  'filter': True, 'fil_thr': 90, 'fil_opp': 95, 'a1': 1, 'b1': 1}, \
    'anchor': {'l_rate': 0.002821181655865712, 'l2': 0.011839034735233178, 'batch': 5, 'n_layer': 2, 'layer_s': 100, \
                  'a1': 0.7738530472331953, 'b1': 1}, \
} 

adult_ranges_r = \
{
    'baseline_plain_clean': {'l_rate': [0.0001, 0.01], 'l2': [0.001, 0.1], 'batch': [5, 5], 'n_layer': [2, 2], 'layer_s': [10, 10], \
                  'filter': [False, False], 'fil_thr':[100, 100], 'fil_opp':[100, 100], 'a1': [1, 1], 'add_noise': [False, False], \
                   'noise_amnt': [0.1, 0.1]}, \
    'baseline_plain': {'l_rate': [0.0001, 0.01], 'l2': [0.001, 0.1], 'batch': [5, 5], 'n_layer': [2, 2], 'layer_s': [10, 10], \
                  'filter': [False, False], 'fil_thr':[80, 80], 'fil_opp':[90, 90], 'a1': [1, 1], 'add_noise': [False, False], \
                   'noise_amnt': [0.1, 0.1]}, \
    'baseline_sln_filt': {'l_rate': [0.0001, 0.01], 'l2': [0.01, 0.1], 'batch': [5, 5], 'n_layer': [2, 2], 'layer_s': [10, 10], \
                  'filter': [True, True], 'fil_thr':[50, 100], 'fil_opp':[100, 100], 'a1': [0.1, 0.10], 'add_noise': [True, True], \
                   'noise_amnt': [0.001, 0.1]}, \
    'baseline_transition': {'l_rate': [0.0001, 0.01], 'l2': [0.001, 0.1], 'batch': [5, 5], 'n_layer': [2, 2], 'layer_s': [10, 10], \
                  'fil_thr':[50, 50], 'fil_thr2':[90, 90], 'num_parts': [1, 10], 'a1': [0.01, 10], 'a2': [0.01, 10], 'a3':[0.1, 10]}, \
    'baseline_transit_conf': {'l_rate': [0.0001, 0.01], 'l2': [0.001, 0.1], 'batch':[5, 5], 'n_layer':[2, 2],'layer_s':[10, 10]},\
    'baseline_fair_gpl': {'l_rate': [0.0001, 0.01], 'l2': [0.001, 0.1], 'batch': [5, 5], 'n_layer': [2, 2], 'layer_s': [10, 10], \
                  'weight_lr': [0.0001, 0.0001], 'a1': [0.001, 0.01]}, \
    'baseline_js_loss': {'l_rate': [0.0001, 0.01], 'l2': [0.001, 0.1], 'batch':[5, 5], 'n_layer':[2, 2], 'layer_s':[10, 10], \
                  'pi':[0.01, 0.1]}, \
    'proposed1': {'l_rate': [0.0001, 0.01], 'l2': [0.001, 0.1], 'batch': [5, 5], 'n_layer': [2, 2], 'layer_s': [10, 10], \
                  'a1': [0.1, 10], 'b1':[0.1, 10], 'c1': [0.1, 10]}, \
}

adult_ranges_f2 = \
{
    'baseline_plain_clean': {'l_rate': [0.0001, 0.01], 'l2': [0.001, 0.1], 'batch': [5, 5], 'n_layer': [2, 2], 'layer_s': [10, 10], \
                  'filter': [False, False], 'fil_thr':[100, 100], 'fil_opp':[100, 100], 'a1': [1, 1], 'add_noise': [False, False], \
                   'noise_amnt': [0.1, 0.1]}, \
    'baseline_plain': {'l_rate': [0.0001, 0.01], 'l2': [0.001, 0.1], 'batch': [5, 5], 'n_layer': [2, 2], 'layer_s': [10, 10], \
                  'filter': [False, False], 'fil_thr':[80, 80], 'fil_opp':[90, 90], 'a1': [1, 1], 'add_noise': [False, False], \
                   'noise_amnt': [0.1, 0.1]}, \
    'baseline_sln_filt': {'l_rate': [0.0001, 0.01], 'l2': [0.001, 0.1], 'batch': [5, 5], 'n_layer': [2, 2], 'layer_s': [10, 10], \
                  'filter': [True, True], 'fil_thr':[50, 100], 'fil_opp':[100, 100], 'a1': [0.1, 0.10], 'add_noise': [True, True], \
                   'noise_amnt': [0.001, 0.1]}, \
    'baseline_transition': {'l_rate': [0.001, 0.01], 'l2': [0.001, 0.1], 'batch': [5, 5], 'n_layer': [2, 2], 'layer_s': [10, 10], \
                  'fil_thr':[50, 50], 'fil_thr2':[90, 90], 'num_parts': [1, 10], 'a1': [0.1, 10], 'a2': [0.1, 10], 'a3': [0.1, 10]}, \
    'baseline_transit_conf': {'l_rate': [0.0001, 0.01], 'l2': [0.001, 0.1], 'batch':[5, 5], 'n_layer':[2, 2],'layer_s':[10, 10]},\
    'baseline_fair_gpl': {'l_rate': [0.0001, 0.01], 'l2': [0.001, 0.1], 'batch': [5, 5], 'n_layer': [2, 2], 'layer_s': [10, 10], \
                  'weight_lr': [0.0001, 0.0001], 'a1': [0.001, 0.01]}, \
    'baseline_js_loss': {'l_rate': [0.0001, 0.01], 'l2': [0.001, 0.1], 'batch':[5, 5], 'n_layer':[2, 2], 'layer_s':[10, 10], \
                  'pi':[0.01, 0.1]}, \
    'proposed1': {'l_rate': [0.001, 0.01], 'l2': [0.001, 0.1], 'batch': [5, 5], 'n_layer': [2, 2], 'layer_s': [10, 10], \
                  'a1': [0.1, 10], 'b1':[0.1, 10], 'c1': [0.1, 10]}, \
    #'proposed1': {'l_rate': [0.001, 0.01], 'l2': [0.001, 0.1], 'batch': [5, 5], 'n_layer': [2, 2], 'layer_s': [10, 10], \
    #              'a1': [0.01, 10], 'b1':[0.01, 10], 'c1': [0.01, 10]}, \
}


'''
compas dataset from fairness literature
'''
compas_hyperparams = \
{
    'baseline_plain_clean': {'l_rate': 0.001, 'l2': 0.01, 'batch': 5, 'n_layer': 2, 'layer_s': 100, \
                  'filter': False, 'fil_thr': 0.8, 'fil_opp': 0.9, 'transit': False, 'a1': 0.1, 'add_noise': False}, \
    'baseline_plain': {'l_rate': 0.001, 'l2': 0.01, 'batch': 5, 'n_layer': 2, 'layer_s': 100, \
                  'filter': False, 'fil_thr': 0.8, 'fil_opp': 0.9, 'transit': False, 'a1': 0.1, 'add_noise': False}, \
    'baseline_sln_filt': {'l_rate': 0.001, 'l2': 0.01, 'batch': 5, 'n_layer': 2, 'layer_s': 100, \
                  'filter': True, 'fil_thr': 90, 'fil_opp': 95, 'transit': False, 'a1': 0.1, 'add_noise': True}, \
    'baseline_transition': {'l_rate': 0.01, 'l2': 0.8, 'batch': 5, 'n_layer': 2, 'layer_s': 20, \
                  'fil_thr': 0.8, 'num_parts': 3, 'a1': 0.25, 'a2': 1}, \
    'baseline_transit_conf': {'l_rate': 0.01, 'l2': 0.8, 'batch': 5, 'n_layer': 2, 'layer_s': 20}, \
    'baseline_fair_gpl': {'l_rate': 0.001, 'l2': 0.01, 'batch': 5, 'n_layer': 2, 'layer_s': 100, \
                  'weight_lr': 0.001, 'a1': 0.1}, \
    'baseline_js_loss': {'l_rate': 0.001, 'l2': 0.01, 'batch': 5, 'n_layer': 2, 'layer_s': 100, 'pi': 0.5}, \
    'proposed1': {'l_rate': 0.001, 'l2': 0.01, 'batch': 5, 'n_layer': 2, 'layer_s': 100, \
                  'filter': True, 'fil_thr': 90, 'fil_opp': 95, 'a1': 1, 'b1': 1}, \
    'anchor': {'l_rate': 0.002821181655865712, 'l2': 0.011839034735233178, 'batch': 5, 'n_layer': 2, 'layer_s': 100, \
                  'a1': 0.7738530472331953, 'b1': 1}, \
} 

compas_ranges_r = \
{
    'baseline_plain_clean': {'l_rate': [0.0001, 0.01], 'l2': [0.0001, 0.01], 'batch': [5, 5], 'n_layer': [2, 2], 'layer_s': [10, 10], \
                  'filter': [False, False], 'fil_thr':[100, 100], 'fil_opp':[100, 100], 'a1': [1, 1], 'add_noise': [False, False], \
                   'noise_amnt': [0.1, 0.1]}, \
    'baseline_plain': {'l_rate': [0.0001, 0.01], 'l2': [0.0001, 0.01], 'batch': [5, 5], 'n_layer': [2, 2], 'layer_s': [10, 10], \
                  'filter': [False, False], 'fil_thr':[80, 80], 'fil_opp':[90, 90], 'a1': [1, 1], 'add_noise': [False, False], \
                   'noise_amnt': [0.1, 0.1]}, \
    'baseline_sln_filt': {'l_rate': [0.00001, 0.01], 'l2': [0.0001, 0.001], 'batch': [5, 5], 'n_layer': [2, 2], 'layer_s': [10, 10], \
                  'filter': [True, True], 'fil_thr':[50, 90], 'fil_opp':[100, 100], 'a1': [0.1, 0.10], 'add_noise': [True, True], \
                   'noise_amnt': [0.0001, 0.01]}, \
    'baseline_transition': {'l_rate': [0.0001, 0.01], 'l2':[0.0001, 0.01], 'batch': [5, 5], 'n_layer': [2, 2], 'layer_s': [10, 10], \
                  'fil_thr':[50, 50], 'fil_thr2':[90, 90], 'num_parts': [1, 10], 'a1': [0.01, 10], 'a2': [0.01, 10], 'a3': [0.1, 10]}, \
    'baseline_transit_conf': {'l_rate': [0.0001, 0.01], 'l2': [0.0001, 0.01], 'batch':[5, 5], 'n_layer':[2, 2],'layer_s':[10, 10]},\
    'baseline_fair_gpl': {'l_rate': [0.0001, 0.01], 'l2': [0.00001, 0.01], 'batch': [5, 5], 'n_layer': [2, 2], 'layer_s': [10, 10], \
                  'weight_lr': [0.0001, 0.0001], 'a1': [0.01, 1]}, \
    'baseline_js_loss': {'l_rate': [0.0001, 0.01], 'l2': [0.0001, 0.01], 'batch':[5, 5], 'n_layer':[2, 2], 'layer_s':[10, 10], \
                  'pi':[0.01, 0.1]}, \
    'proposed1': {'l_rate': [0.0001, 0.01], 'l2': [0.0001, 0.01], 'batch': [5, 5], 'n_layer': [2, 2], 'layer_s': [10, 10], \
                  'a1': [0.01, 10], 'b1':[0.01, 10], 'c1': [0.01, 10]}, \
}

compas_ranges_f2 = \
{
    'baseline_plain_clean': {'l_rate': [0.0001, 0.01], 'l2':[0.001, 0.01], 'batch':[5, 5], 'n_layer': [2, 2], 'layer_s': [10, 10], \
                  'filter': [False, False], 'fil_thr':[100, 100], 'fil_opp':[100, 100], 'a1': [1, 1], 'add_noise': [False, False], \
                   'noise_amnt': [0.1, 0.1]}, \
    #'baseline_plain_clean': {'l_rate': [0.0001, 0.01], 'l2': [0.001, 0.01], 'batch': [5, 5], 'n_layer': [2, 2], 'layer_s': [10, 10], \
    #              'filter': [False, False], 'fil_thr':[100, 100], 'fil_opp':[100, 100], 'a1': [1, 1], 'add_noise': [False, False], \
    #               'noise_amnt': [0.1, 0.1]}, \
    'baseline_plain': {'l_rate': [0.0001, 0.01], 'l2': [0.0001, 0.01], 'batch': [5, 5], 'n_layer': [2, 2], 'layer_s': [10, 10], \
                  'filter': [False, False], 'fil_thr':[80, 80], 'fil_opp':[90, 90], 'a1': [1, 1], 'add_noise': [False, False], \
                  'noise_amnt': [0.1, 0.1]}, \
    'baseline_sln_filt': {'l_rate': [0.00001, 0.01], 'l2': [0.0001, 0.001], 'batch': [5, 5], 'n_layer': [2, 2], 'layer_s': [10, 10], \
                  'filter': [True, True], 'fil_thr':[50, 90], 'fil_opp':[100, 100], 'a1': [0.1, 0.10], 'add_noise': [True, True], \
                   'noise_amnt': [0.0001, 0.01]}, \
    'baseline_transition': {'l_rate': [0.00001, 0.01], 'l2':[0.0001, 0.01], 'batch': [5, 5], 'n_layer': [2, 2], 'layer_s': [10, 10], \
                  'fil_thr':[50, 50], 'fil_thr2':[90, 90], 'num_parts': [1, 10], 'a1': [0.01, 1], 'a2': [0.01, 1], 'a3': [0.1, 10]}, \
    'baseline_transit_conf': {'l_rate': [0.0001, 0.01], 'l2': [0.0001, 0.01], 'batch':[5, 5], 'n_layer':[2, 2],'layer_s':[10, 10]},\
    'baseline_fair_gpl': {'l_rate': [0.0001, 0.01], 'l2': [0.00001, 0.01], 'batch': [5, 5], 'n_layer': [2, 2], 'layer_s': [10, 10], \
                  'weight_lr': [0.0001, 0.0001], 'a1': [0.01, 1]}, \
    'baseline_js_loss': {'l_rate': [0.0001, 0.01], 'l2': [0.0001, 0.01], 'batch':[5, 5], 'n_layer':[2, 2], 'layer_s':[10, 10], \
                  'pi':[0.01, 0.1]}, \
    'proposed1': {'l_rate': [0.001, 0.01], 'l2': [0.001, 0.01], 'batch': [5, 5], 'n_layer': [2, 2], 'layer_s': [10, 10], \
                  'a1': [0.01, 10], 'b1':[0.01, 10], 'c1': [0.01, 10]}, \
}

###################################################################################################
'''
putting everything together
'''

all_hyperparams = \
{
    'synth_random': synth1_hyperparams, \
    'synth_feat2': synth1_hyperparams, \
    'MIMIC-ARF-random': mimic_arf_hyperparams, \
    'MIMIC-ARF-feat2': mimic_arf_hyperparams, \
    'MIMIC-Shock-random': mimic_shock_hyperparams, \
    'MIMIC-Shock-feat2': mimic_shock_hyperparams, \
    'adult-random': adult_hyperparams, \
    'adult-feat2': adult_hyperparams, \
    'compas-random': compas_hyperparams, \
    'compas-feat2': compas_hyperparams, \
}

hp_ranges = \
{
    'synth_random': synth1_rand_ranges, \
    'synth_feat2': synth1_ranges_f2, \
    'MIMIC-ARF-random': mimic_arf_ranges_rand, \
    'MIMIC-ARF-feat2': mimic_arf_ranges_f2, \
    'MIMIC-Shock-random': mimic_shock_ranges_rand, \
    'MIMIC-Shock-feat2': mimic_shock_ranges_f2, \
    'adult-random': adult_ranges_r, \
    'adult-feat2': adult_ranges_f2, \
    'compas-random': compas_ranges_r, \
    'compas-feat2': compas_ranges_f2, \
}

###################################################################################################
'''
main block 
'''
if __name__ == '__main__':
    print(':)')
