# @title
# Import necessary libraries
import numpy as np
import matplotlib.pyplot as plt

# Function to compute the expected value for a given rho
def compute_expected_value(rho, mu, sigma):
    # Placeholder for the actual computation of expected value based on p_rho
    # This should be replaced with the specific formula or computation for the expected value
    expected_value = rho * mu  # Example computation, replace with actual formula
    return expected_value

# Parameters
mu = 0.5
sigma = 0.1

# Generate rho values from 0 to 1
rhos = np.linspace(0.01, 1, 100)

# Compute expected values for each rho
expected_values = [compute_expected_value(rho, mu, sigma) for rho in rhos]

# Plotting
plt.figure(figsize=(10, 6))
plt.plot(rhos, expected_values, label=r'$\mathbb{E}_{v\sim p_{\rho}}[v]$')
plt.xlabel('Bias $\\rho$', fontsize=25)
plt.ylabel(r'Expected value of $p_{\rho}$', fontsize=25)
plt.title(r'Plot of $\mathbb{E}_{v\sim p_{\rho}}[v]$ for $\mu = 0.5$, $\sigma = 0.1$', fontsize=25)
# plt.legend(fontsize=20)
plt.grid(True)

# Adjust tick label sizes
plt.xticks(fontsize=25)
plt.yticks(fontsize=25)
plt.show()
