# Import necessary libraries
import numpy as np
import matplotlib.pyplot as plt
from scipy.stats import truncnorm

# Function to compute the expected value for a given rho
def compute_expected_value(rho, mu, sigma):
    # Define the limits of the truncated normal distribution
    a, b = (0 - rho * mu) / sigma, (1 - rho * mu) / sigma
    # Compute the expected value of the truncated normal distribution
    expected_value = truncnorm.mean(a, b, loc=rho * mu, scale=sigma)
    return expected_value

# Function to get the PDF of a truncated normal distribution for plotting
def get_truncated_normal_pdf(rho, mu, sigma, points):
    a, b = (0 - rho * mu) / sigma, (1 - rho * mu) / sigma
    return truncnorm.pdf(points, a, b, loc=rho * mu, scale=sigma)

# Parameters
mu = 0.5
sigma = 0.1

# Generate rho values from 0 to 1 for the expected value plot
rhos = np.linspace(0, 1, 100)

# Compute expected values for each rho
expected_values = [compute_expected_value(rho, mu, sigma) for rho in rhos]

# Points for density plots
points = np.linspace(0, 1, 400)

# Plotting
plt.figure(figsize=(10, 6))

# Plot densities for selected rho values
for rho in [0, 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1]:
    pdf = get_truncated_normal_pdf(rho, mu, sigma, points)
    plt.plot(points, pdf, label=f'$\\rho={rho}$')

plt.xlabel('')
plt.ylabel('')
plt.title(r'Density $p_\rho$', fontsize = 25)
plt.legend(fontsize=16)
plt.grid(True)

# Adjust tick label sizes
plt.xticks(fontsize=25)
plt.yticks(fontsize=25)
plt.show()
