import numpy as np
import matplotlib.pyplot as plt

# Problem sizes
n = np.array([20, 200, 600, 1200, 2000])

# Observed convergence rates for two sequences (replace these with your actual data)
s1 = np.array([0.08, 0.05, 0.032, 0.025, 0.02])
s2 = np.array([0.08, 0.05, 0.0246, 0.020, 0.018])

# Theoretical reference curve 1/sqrt(n)
ref = 1 / np.sqrt(n)

plt.figure(figsize=(6, 4))

# Plot the observed rates
plt.plot(n, s1, 'o-', label=r'$s_{1}$', markersize=6)
plt.plot(n, s2, 's-', label=r'$s_{2}$', markersize=6)

# Plot the reference 1/sqrt(n) curve
plt.plot(n, ref, 'k--', label=r'$1/\sqrt{n}$')

# Log–log scale
plt.xscale('log')
plt.yscale('log')

# Force x‐ticks to exactly the values in n
plt.xticks(n, n)

# Labels, title, legend, grid
plt.xlabel(r'$n$', fontsize=20)
plt.ylabel(r'$\Delta_{\infty}$', fontsize=20)
plt.title(r'Distance to $s$ for various of $n$', fontsize=20)
plt.legend(fontsize=20, loc='upper right')
plt.grid(which='both', linestyle=':')

plt.tight_layout()
plt.show()
