# t v.s. rho for various c for Uniform with p_a = uniform
import numpy as np
import matplotlib.pyplot as plt

# Parameters
alpha = 0.5  # Fixed alpha value
c_values = [0.1, 0.2, 0.3, 0.4, 0.5]  # Different c values to plot

# Define the range for rho
rho_range = np.linspace(0.001, 1, 1000)  # Dense range for smooth plotting

# Constants for K0, K1, K2 as functions of rho
def K_0(rho, alpha):
    return (1 - alpha) * (1 - rho)**2 / 2

def K_1(rho, alpha):
    return 1 / 2 - alpha / 2 + alpha * rho / 2

def K_2(rho, alpha):
    return 1 - rho**2 / 2 + alpha * rho**2 / 2 - alpha * rho / 2

# Plotting setup
plt.figure(figsize=(10, 6))

# Loop through each c value
for c in c_values:
    # Calculate t_rho for each rho using the updated formula
    t_rho_values = np.zeros_like(rho_range)

    # Loop through each value of rho in the range
    for i, rho in enumerate(rho_range):
        k0 = K_0(rho, alpha)
        k1 = K_1(rho, alpha)
        k2 = K_2(rho, alpha)

        if c <= k0:
            # Case 1: 0 < c <= K_0
            t_rho_values[i] = 2 - np.sqrt(2 * c / (1 - alpha))
        elif k0 < c <= k1:
            # Case 2: K_0 <= c <= K_1
            t_rho_values[i] = (
                (2 - alpha + alpha / rho) / (1 - alpha + alpha / rho)
                - np.sqrt(
                    2 * c * (1 - alpha + alpha / rho) - alpha * (1 - alpha) * (1 - rho)**2 / rho
                ) / (1 - alpha + alpha / rho)
            )
        elif k1 < c <= k2:
            # Case 3: K_1 <= c <= K_2
            t_rho_values[i] = (
                -alpha / (1 - alpha)
                + np.sqrt(alpha**2 + (1 - alpha) * (2 + alpha * rho - 2 * c)) / (1 - alpha)
            )
        else:
            # Case 4: K_2 <= c <= 1
            t_rho_values[i] = np.sqrt(2 * (1 - c) / (1 - alpha + alpha / rho))

    # Plotting t_rho for each c
    plt.plot(rho_range, t_rho_values, label=f'$c={c}$')

# Finalizing the plot
plt.title('Plot of $t_\\rho$ for various $c$ with $\\alpha=0.5$', fontsize=25)
plt.xlabel('Bias $\\rho$', fontsize=25)
plt.ylabel('Threshold $t_\\rho$', fontsize=25)
plt.legend(fontsize=20, loc='upper left', bbox_to_anchor=(1.02, 1))
plt.grid(True)

# Adjust tick label sizes
plt.xticks(fontsize=25)
plt.yticks(fontsize=25)
plt.show()
