import numpy as np
import matplotlib.pyplot as plt
from scipy.optimize import fsolve
from scipy.integrate import quad
from scipy.optimize import brentq
from scipy.stats import truncnorm


# Parameters for both scenarios
alpha = 0.3
rho = 0.8

# c range
c_range = np.linspace(0.001, 1, 1000)  # Adjust as needed

# Uniform Distribution S_1 and S_2 functions (adjust these based on your first scenario)
def S1_A_uniform(c):
    condition = rho < 1 - c/(1 - alpha)
    return np.where(condition, c**2 / (2 * ((1 - alpha)**2)), ((1 - rho + (1 - alpha)*rho + c*rho - (1 - alpha))**2) / (2 * (1 + (1 - alpha)*rho - (1 - alpha))**2))

def S2_A_uniform(c):
    condition = rho < 1 - c/(1 - alpha)
    return np.where(condition, 0, (rho * ((1 - alpha)*rho + c - (1 - alpha))**2) / (2 * (1 + (1 - alpha)*rho - (1 - alpha))**2))

# Calculate S_2/S_1 for Uniform
S1_values_uniform = S1_A_uniform(c_range)
S2_values_uniform = S2_A_uniform(c_range)
S2_S1_ratio_uniform = S2_values_uniform / S1_values_uniform

# Find c where S_2/S_1 is closest to 0.8
index_closest_to_08 = np.abs(S2_S1_ratio_uniform - 0.8).argmin()
c_closest_to_08 = c_range[index_closest_to_08]

# Plotting
plt.figure(figsize=(10, 6))
plt.plot(c_range, S2_S1_ratio_uniform, label=r'$r_{\mathcal{S}}(A)$ for uniform', color='blue')

# Plot the modified axhline and axvline
plt.plot([0, c_closest_to_08], [0.8, 0.8], color='gray', linestyle='--')  # Horizontal line
plt.plot([c_closest_to_08, c_closest_to_08], [0, 0.8], color='gray', linestyle='--')  # Vertical line

plt.scatter([c_closest_to_08], [0.8], color='gray', zorder=5)  # Mark the intersection

# Calculate offsets
xlim = plt.xlim()  # Get the current x-axis limits
ylim = plt.ylim()  # Get the current y-axis limits
x_offset = (xlim[1] - xlim[0]) * 0.01  # Calculate x offset as a percentage of the x-axis range
y_offset = (ylim[1] - ylim[0]) * 0.02  # Calculate y offset as a percentage of the y-axis range

# Place the text left (with x_offset) and above (with y_offset) the scatter point
plt.text(c_closest_to_08 - x_offset, 0.8 - y_offset, f'({c_closest_to_08:.3f}, 0.8)',
         verticalalignment='top', horizontalalignment='right', fontsize=25)

plt.title(r'Plot of $r_{\mathcal{S}}(A)$ for $\rho = 0.8$, $\alpha = 0.3$', fontsize=25)
plt.xlabel(r'$c$', fontsize=25)
plt.ylabel(r'Social welfare ratio $r_{\mathcal{S}}(A)$', fontsize=25)
# plt.legend()
plt.grid(True)

# Adjust tick label sizes
plt.xticks(fontsize=25)
plt.yticks(fontsize=25)
plt.show()
