# t v.s. rho for various c for Uniform with p_a = 0
import numpy as np
import matplotlib.pyplot as plt

# Parameters
alpha = 0.5  # Fixed alpha value
c_values = [0.1, 0.2, 0.3, 0.4, 0.5]  # Different c values to plot

# Define the range for rho
rho_range = np.linspace(0, 1, 1000)  # Dense range for smooth plotting

# Plotting setup
plt.figure(figsize=(10, 6))

# Loop through each c value
for c in c_values:
    # Calculate t_rho based on the conditions
    t_rho_values = np.where(
        rho_range < 1 - c / (1 - alpha),
        1 - c / (1 - alpha),
        (rho_range * (1 - c)) / (rho_range - alpha * rho_range + alpha)
    )

    # Plotting t_rho for each c
    plt.plot(rho_range, t_rho_values, label=f'$c={c}$')

# Finalizing the plot
plt.title(r'Plot of $t_\rho$ for various $c$ with $\alpha=0.5$', fontsize=25)
plt.xlabel(r'Bias $\rho$', fontsize=25)
plt.ylabel(r'Threshold $t_\rho$', fontsize=25)
plt.legend(fontsize=20, loc='upper left', bbox_to_anchor=(1.02, 1))
plt.grid(True)

# Adjust tick label sizes
plt.xticks(fontsize=25)
plt.yticks(fontsize=25)
plt.show()
