# Nonparametric boundary geometry

## Install dependencies

The project environment is managed with
[`poetry`](https://python-poetry.org). To setup the environment first
run `poetry env use 3.8` to create the virtual environment and then
`poetry install` to setup dependencies. Python 3.8 is required due to
certain dependencies, so make sure it is installed on your system.

To activate and use the virtual environment run `poetry shell`. Alternatively,
any commands can be prefixed with `poetry run`.

## Download and process data

The dataset we use is available at:
https://fusion-360-gallery-dataset.s3-us-west-2.amazonaws.com/assembly/a1.0.0/a1.0.0_00.7z.
Download instructions are available at
https://github.com/AutodeskAILab/Fusion360GalleryDataset/tree/master/tools/assembly_download.

It should be unzipped into the folder `data/raw/fusion`, you can optionally run the script
[download.sh](data/raw/fusion/download.sh) from that directory to do this for
you if you have `7z` installed.

Once the data has been downloaded and unzipped, it can be processed and cleaned
with `python -m pde.data`. This will produce many warning and error messages as
it goes through each mesh in the dataset. These can be safely ignored; only meshes
which are successfully processed will be saved as training data.

Validation data is included in this directory, however you can generate your own
using the program [`FreeFem`](https://freefem.org). To do this meshes first need
to be tesselated using `python -m pde generate-fem-mesh path/to/meshes/*.obj`
and then the finite element solver can be run as
`FreeFem++ fem/helmholtz.edp my/mesh/name.mesh` or similar. See the config files
for examples of how to specify paths to you validation data.

## Training and testing the model

Once training and validation data has been generated, the model can be trained
using eg: `python -m pde train --config helm-config.yml`. The config files specify
the model architecture, training and validation configurations, data paths and
many other parameters.

Testing can be done with a saved model checkpoint using `python -m pde test
ckpt path/to/meshes/*.vtu output-directory`.

For more information on each command run `python -m pde --help` or `python -m
pde train --help`, etc.
