#define CONCEPTS 18
#define SUBJECTS 12
#define FOLDS 8
#define SAMPLES 16000
#define TRUE (0==0)
#define FALSE (0!=0)

struct point {
  double x;
  double y;
};

int tp(int n, double confidence[n], int target[n], double threshold);

int fp(int n, double confidence[n], int target[n], double threshold);

int fn(int n, double confidence[n], int target[n], double threshold);

int tn(int n, double confidence[n], int target[n], double threshold);

double recall(int tp, int fp, int fn, int tn);

double true_negative_rate(int tp, int fp, int fn, int tn);

double precision(int tp, int fp, int fn, int tn);

double negative_predictive_value(int tp, int fp, int fn, int tn);

double false_negative_rate(int tp, int fp, int fn, int tn);

double false_positive_rate(int tp, int fp, int fn, int tn);

double false_discovery_rate(int tp, int fp, int fn, int tn);

double accuracy(int tp, int fp, int fn, int tn);

double f1_score(int tp, int fp, int fn, int tn);

double mcc(int tp, int fp, int fn, int tn);

double score(double (*measure)(int, int, int, int),
	     double threshold,
	     int n,
	     double confidence[n],
	     int target[n]);

int compare_doubles(const void *x, const void *y);

int compare_points(const void *x, const void *y);

double auc(double (*measure1)(int, int, int, int),
	   double (*measure2)(int, int, int, int),
	   int n,
	   double confidence[n],
	   int target[n]);

double mean_auc(double (*measure1)(int, int, int, int),
		double (*measure2)(int, int, int, int),
		int subjects,
		int n,
		double confidence[subjects][n],
		int target[subjects][n]);

double pooled_subject_mean_auc(double (*measure1)(int, int, int, int),
			       double (*measure2)(int, int, int, int),
			       int folds,
			       int n,
			       double confidence[folds][n],
			       int target[folds][n]);

double pooled_subject_cross_modal_mean_auc
(double (*measure1)(int, int, int, int),
 double (*measure2)(int, int, int, int),
 int n,
 double confidence[n],
 int target[n]);

double p_value_by_sampling(double (*measure1)(int, int, int, int),
			   double (*measure2)(int, int, int, int),
			   int subjects,
			   int n,
			   double confidence[subjects][n],
			   int target[subjects][n],
			   int m);

double pooled_subject_p_value_by_sampling(double (*measure1)(int, int, int, int),
					  double (*measure2)(int, int, int, int),
					  int folds,
					  int n,
					  double confidence[folds][n],
					  int target[folds][n],
					  int m);

double pooled_subject_cross_modal_p_value_by_sampling
(double (*measure1)(int, int, int, int),
 double (*measure2)(int, int, int, int),
 int n,
 double confidence[n],
 int target[n],
 int m);

int main(int argc, char *argv[argc]);
