import pickle as pkl

directory = "/aux/USER/fmri-datasets/predication/processed/experiments"
HRFdelay = 3
layers = 1
hidden = 10

concept_files = ["Dan",
                 "Scott",
                 "pick-up",
                 "put-down",
                 "briefcase",
                 "chair",
                 "Dan-pick-up1",
                 "Scott-pick-up1",
                 "Dan-put-down1",
                 "Scott-put-down1",
                 "Dan-briefcase1",
                 "Dan-chair1",
                 "Scott-briefcase1",
                 "Scott-chair1",
                 "pick-up-briefcase1",
                 "put-down-briefcase1",
                 "pick-up-chair1",
                 "put-down-chair1"]

def pkl_filename(subject, concept, modality, kind, identifier):
    return "%s/subject-%02d/%s/%s-%s-%s-%d-%s-%s.pkl"%(
        directory,
        subject+1,
        modality,
        concept,
        kind,
        identifier,
        HRFdelay,
        "nn-%d-%d"%(layers, hidden),
        "whole-brain")

def pooled_pkl_filename(concept, modality, kind, identifier):
    return "%s/pooled-subject/%s/%s-%s-%s-%d-%s-%s.pkl"%(
        directory,
        modality,
        concept,
        kind,
        identifier,
        HRFdelay,
        "nn-%d-%d"%(layers, hidden),
        "whole-brain")

for modality in ["video", "text"]:
    for concept in concept_files:
        detections = pkl.load(
            open(pooled_pkl_filename(
                concept, modality, "pooled-subject", "iclr2024"),
                 "rb"))
        file = open("detections/pooled-subject-%s-%s.txt"%(concept, modality),
                    "w")
        file.write("%d\n"%len(detections))
        for confidence, target in detections:
            file.write("%0.18f %d\n"%(confidence, target))
        file.close()
        detections = []
        for subject in range(12):
            detections += pkl.load(
                open(pkl_filename(
                    subject, concept, modality, "cross-subject", "iclr2024"),
                     "rb"))
        file = open("detections/cross-subject-%s-%s.txt"%(concept, modality),
                    "w")
        file.write("%d\n"%len(detections))
        for confidence, target in detections:
            file.write("%0.18f %d\n"%(confidence, target))
        file.close()
        detections = pkl.load(
            open(pooled_pkl_filename(
                concept, modality, "pooled-subject-cross-modal", "iclr2024"),
                 "rb"))
        file = open("detections/pooled-subject-cross-modal-%s-%s.txt"%(
            concept, modality),
                    "w")
        file.write("%d\n"%len(detections))
        for confidence, target in detections:
            file.write("%0.18f %d\n"%(confidence, target))
        file.close()
