def strip_newlines(strings):
    return list(map(lambda string: string[:-1], strings))

def auc(s):
    return s[34:42]

def significance(s):
    if s[-1]=="*":
        return "\\sig"
    else:
        return "\\notsig"

def render(s):
    return auc(s)+significance(s)

single_subject = strip_newlines(open("/home/USER/fmri-experiments/predication/python-predication/results-r9feb2023/auc.txt", "r").readlines())
cross_modal = strip_newlines(open("/home/USER/fmri-experiments/predication/python-cross-modal/results-h11feb2023/auc.txt", "r").readlines())
cross_subject = strip_newlines(open("/home/USER/fmri-experiments/predication/python-cross-subject/results-s12feb2023/auc.txt", "r").readlines())
pooled_subject = strip_newlines(open("/home/USER/fmri-experiments/predication/python-pooled-subject/results-m13feb2023/auc.txt", "r").readlines())

f = open("table.tex", "w")
f.write("\\begin{tabular}{lrrrrrrrr}\n")
for i, concept in enumerate(["Dan",
                             "Scott",
                             "briefcase",
                             "chair",
                             "pick up",
                             "put down",
                             "subject swapping",
                             "object swapping",
                             "Dan pick up (contrastive)",
                             "Scott pick up (contrastive)",
                             "Dan put down (contrastive)",
                             "Scott put down (contrastive)",
                             "Dan briefcase (contrastive)",
                             "Dan chair (contrastive)",
                             "Scott briefcase (contrastive)",
                             "Scott chair (contrastive)",
                             "pick up briefcase (contrastive)",
                             "put down briefcase (contrastive)",
                             "pick up chair (contrastive)",
                             "put down chair (contrastive)",
                             "Dan pick up (all)",
                             "Dan put down (all)",
                             "Scott pick up (all)",
                             "Scott put down (all)",
                             "Dan briefcase (all)",
                             "Dan chair (all)",
                             "Scott briefcase (all)",
                             "Scott chair (all)",
                             "pick up briefcase (all)",
                             "pick up chair (all)",
                             "put down briefcase (all)",
                             "put down chair (all)"]):
    f.write("\\emph{%s}"%concept)
    f.write("&%s"%render(single_subject[i]))
    f.write("&%s"%render(single_subject[i+32]))
    f.write("&%s"%render(cross_modal[i]))
    f.write("&%s"%render(cross_modal[i+32]))
    f.write("&%s"%render(cross_subject[i]))
    f.write("&%s"%render(cross_subject[i+32]))
    f.write("&%s"%render(pooled_subject[i]))
    f.write("&%s"%render(pooled_subject[i+32]))
    f.write("\\\\\n")
f.write("\\end{tabular}\n")
