 ;;; I adopt the naming conventions from
;;; /net/aql/aux/abarbu/fmri-datasets/9events/9events/data/subject1

(define *experiment* "predication")
(define *slices* 35)
(define *trs* 254)
(define *tr-in-milliseconds* 2000)

(define (to3d p-directory e-directory s-directory subject file files)
 (cd (string-append "/aux/USER/fmri-datasets/"
		    *experiment*
		    "/scans/"
		    p-directory
		    "/"
		    e-directory
		    "/"
		    s-directory))
 (with-temporary-file
  "/tmp/to3d.sh"
  (lambda (tmp)
   (write-file
    (list "#!/bin/bash"
	  "PATH=$PATH:/usr/lib/afni/bin"
	  (format #f "to3d -epan -prefix ~a -time:zt ~s ~s ~s alt+z ~a"
		  file
		  *slices*
		  *trs*
		  *tr-in-milliseconds*
		  files))
    tmp)
   (system (format #f "chmod +x ~a" tmp))
   (system tmp)))
 (cd (string-append "/aux/USER/fmri-datasets/"
		    *experiment*
		    "/scans/"
		    p-directory
		    "/"
		    e-directory
		    "/"
		    s-directory))
 (system (format #f "mv -i ~a ../../../../original/subject-~a/"
		 file (number->padded-string-of-length subject 2))))

(define (dimon p-directory e-directory s-directory subject file files)
 (cd (string-append "/aux/USER/fmri-datasets/"
		    *experiment*
		    "/scans/"
		    p-directory
		    "/"
		    e-directory
		    "/"
		    s-directory))
 (with-temporary-file
  "/tmp/Dimon.sh"
  (lambda (tmp)
   (write-file
    (list "#!/bin/bash"
	  "PATH=$PATH:/usr/lib/afni/bin"
	  (format #f "Dimon -infile_prefix '~a' -dicom_org -gert_filename rs_recon -gert_create_dataset -gert_to3d_prefix ~a -gert_quit_on_err -quit"
		  files file))
    tmp)
   (system (format #f "chmod +x ~a" tmp))
   (system tmp)))
 (cd (string-append "/aux/USER/fmri-datasets/"
		    *experiment*
		    "/scans/"
		    p-directory
		    "/"
		    e-directory
		    "/"
		    s-directory))
 (system (format #f "mv -i ~a ../../../../original/subject-~a/"
		 file (number->padded-string-of-length subject 2))))

(define (i-files p-directory e-directory s-directory)
 (sort (directory-list (string-append "/aux/USER/fmri-datasets/"
				      *experiment*
				      "/scans/"
				      p-directory
				      "/"
				      e-directory
				      "/"
				      s-directory))
       <
       (lambda (file) (string->number (extension file)))))

(define (dicom-functional->afni p-directory e-directory s-directory subject run)
 (let ((files (i-files p-directory e-directory s-directory)))
  (unless (= (length files) (* *slices* *trs*))
   (panic "Bad functional ~s ~s" subject run))
  (dimon p-directory e-directory s-directory subject
	 (format #f "epi-r~a.nii.gz" (number->padded-string-of-length run 2))
	 "i*")))

(define (dicom-functional->afni-first-half
	 p-directory e-directory s-directory subject run)
 (let ((files (i-files p-directory e-directory s-directory)))
  (unless (= (length files) (* 2 *slices* *trs*))
   (panic "Bad functional first half ~s ~s" subject run))
  (to3d p-directory e-directory s-directory subject
	(format #f "epi-r~a.nii.gz" (number->padded-string-of-length run 2))
	(reduce (lambda (s1 s2) (string-append s1 " " s2))
		(sublist files 0 (* *slices* *trs*))
		""))))

(define (dicom-functional->afni-second-half
	 p-directory e-directory s-directory subject run)
 (let ((files (i-files p-directory e-directory s-directory)))
  (unless (= (length files) (* 2 *slices* *trs*))
   (panic "Bad functional second half ~s ~s" subject run))
  (to3d p-directory e-directory s-directory subject
	(format #f "epi-r~a.nii.gz" (number->padded-string-of-length run 2))
	(reduce (lambda (s1 s2) (string-append s1 " " s2))
		(sublist files (* *slices* *trs*) (* 2 *slices* *trs*))
		""))))

(define (dicom-check-localizer p-directory e-directory s-directory)
 (let ((files (i-files p-directory e-directory s-directory)))
  (unless (= (length files) 30)
   (panic "Bad localizer ~a ~a ~a" p-directory e-directory s-directory))))

(define (dicom-check-asset-calibration p-directory e-directory s-directory)
 (let ((files (i-files p-directory e-directory s-directory)))
  (unless (= (length files) 78)
   (panic "Bad asset calibration ~a ~a ~a"
	  p-directory e-directory s-directory))))

(define (dicom-check-brainwave p-directory e-directory s-directory)
 (let ((files (i-files p-directory e-directory s-directory)))
  (unless (= (length files) 35)
   (panic "Bad brainwave ~a ~a ~a" p-directory e-directory s-directory))))

(define (dicom-anatomical->afni p-directory e-directory s-directory subject)
 (let ((files (i-files p-directory e-directory s-directory)))
  (unless (= (length files) 168) (panic "Bad anatomical ~s" subject))
  (dimon p-directory e-directory s-directory subject "anat.nii.gz" "i*")))

(define (sort-files files)
 (sort files
       <
       (lambda (file)
	(string->number (list->string (rest (string->list file)))))))

(define (dicom->afni subjects)
 (cd (string-append "/aux/USER/fmri-datasets/" *experiment* "/scans/"))
 (system "rm -rf p[0-9][0-9][0-9][0-9][0-9][0-9][0-9]")
 (cd (string-append "/aux/USER/fmri-datasets/" *experiment*))
 (system "rm -rf original")
 (mkdir "original")
 (for-each-indexed
  (lambda (subject i)
   (let ((j 1))
    (cd (string-append "/aux/USER/fmri-datasets/" *experiment* "/original/"))
    (mkdir (format #f "subject-~a" (number->padded-string-of-length (+ i 1) 2)))
    (for-each
     (lambda (dicom-file)
      (cd (string-append "/aux/USER/fmri-datasets/" *experiment* "/scans/"))
      (system (format #f "tar zxf ~a" (first dicom-file)))
      (let* ((p-files (sort-files
		       (remove-if-not
			(lambda (file)
			 (and (char=? (string-ref file 0) #\p)
			      (every char-numeric? (rest (string->list file)))))
			(directory-list "."))))
	     (e-files (sort-files
		       (map (lambda (p-file)
			     (let ((e-files (directory-list p-file)))
			      (unless (= (length e-files) 1) (fuck-up))
			      (first e-files)))
			    p-files)))
	     (s-files
	      (map (lambda (p-file e-file)
		    (sort-files
		     (directory-list (string-append p-file "/" e-file))))
		   p-files e-files)))
       (unless (= (length p-files) (length (rest dicom-file))) (fuck-up))
       (for-each
	(lambda (p-file e-file s-files dicom-files)
	 (unless (= (length s-files) (length dicom-files)) (fuck-up))
	 (for-each
	  (lambda (s-file dicom-file)
	   (if (list? dicom-file)
	       (case (first dicom-file)
		((functional)
		 (dicom-functional->afni
		  p-file e-file s-file (+ i 1) (second dicom-file)))
		(else (fuck-up)))
	       (case dicom-file
		((discard) #f)
		((skip) (set! j (+ j 1)))
		((localizer) (dicom-check-localizer p-file e-file s-file))
		((brainwave) (dicom-check-brainwave p-file e-file s-file))
		((functional)
		 (dicom-functional->afni p-file e-file s-file (+ i 1) j)
		 (set! j (+ j 1)))
		((functional2)
		 (dicom-functional->afni-first-half
		  p-file e-file s-file (+ i 1) j)
		 (dicom-functional->afni-second-half
		  p-file e-file s-file (+ i 1) (+ j 1))
		 (set! j (+ j 2)))
		((anatomical)
		 (dicom-anatomical->afni p-file e-file s-file (+ i 1)))
		(else (fuck-up)))))
	  s-files dicom-files)
	 (cd (string-append "/aux/USER/fmri-datasets/" *experiment* "/scans/"))
	 (rm p-file))
	p-files e-files s-files (rest dicom-file))))
     subject)))
  subjects))

(define (discarded)
 (dicom->afni
  '((("pred-13-1-dicom.tgz"
      (localizer
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave)
      (localizer
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave
       anatomical))))))

(define (canonize-scan-data-names)
 (dicom->afni
  '((("pred-4-1-dicom.tgz"
      (localizer
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave)
      (localizer
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave
       anatomical))
     ("pred-4-2-dicom.tgz"
      (localizer
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave)
      (discard
       discard
       discard
       discard)
      (discard
       discard)
      (discard
       discard)
      (discard
       discard)
      (discard
       discard)
      (discard
       discard)))
    (("pred-5-1-dicom.tgz"
      (localizer
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave)
      (localizer
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave
       anatomical))
     ("pred-5-2-dicom.tgz"
      (localizer
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave)))
    (("pred-6-1-dicom.tgz"
      (localizer
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave
       discard
       brainwave
       brainwave
       brainwave
       discard
       brainwave
       brainwave
       brainwave
       discard
       brainwave
       brainwave
       brainwave
       discard
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave
       anatomical))
     ("pred-6-1-dicom.tgz"
      (localizer
       discard
       brainwave
       brainwave
       brainwave
       discard
       brainwave
       brainwave
       brainwave
       discard
       brainwave
       brainwave
       brainwave
       discard
       brainwave
       brainwave
       brainwave
       discard
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave
       discard
       brainwave
       brainwave
       brainwave
       discard))
     ("pred-6-2-dicom.tgz"
      (localizer
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave)))
    (("pred-7-1-dicom.tgz"
      (localizer
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave
       anatomical))
     ("pred-7-2-dicom.tgz"
      (localizer
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave)
      (discard
       discard
       discard
       discard)
      (discard
       discard)
      (discard
       discard)
      (discard
       discard)
      (discard
       discard)
      (discard
       discard)
      (discard
       discard)
      (discard
       discard)))
    (("pred-8-1-dicom.tgz"
      (localizer
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave
       anatomical))
     ("pred-8-2-dicom.tgz"
      (localizer
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave)
      (discard
       discard
       discard
       discard)
      (discard
       discard)
      (discard
       discard)
      (discard
       discard)
      (discard
       discard)
      (discard
       discard)))
    (("pred-9-1-dicom.tgz"
      (localizer
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave)
      (localizer
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave
       discard
       discard)
      (localizer
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave
       anatomical))
     ("pred-9-2-dicom.tgz"
      (localizer
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave)))
    (("pred-10-1-dicom.tgz"
      (localizer
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave
       anatomical))
     ("pred-10-2-dicom.tgz"
      (localizer
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave)))
    (("pred-11-1-dicom.tgz"
      (localizer
       discard)
      (localizer
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave)
      (localizer
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave
       anatomical))
     ("pred-11-2-dicom.tgz"
      (localizer
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave)
      (localizer
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave)))
    (("pred-12-1-dicom.tgz"
      (localizer
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave
       anatomical))
     ("pred-12-2-dicom.tgz"
      (localizer
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave)))
    (("pred-16-1-dicom.tgz"
      (localizer
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave
       anatomical))
     ("pred-16-2-dicom.tgz"
      (localizer
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave)))
    (("pred-14-1-dicom.tgz"
      (localizer
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave)
      (localizer
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave
       anatomical)
      (localizer
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave)))
    (("pred-15-1-dicom.tgz"
      (localizer
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave
       anatomical))
     ("pred-15-2-dicom.tgz"
      (localizer
       discard
       discard
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave
       functional
       brainwave
       brainwave
       brainwave))))))

(canonize-scan-data-names)
