(MODULE
 SFT
 (WITH QOBISCHEME XLIB SFTLIB-SC)
 (MAIN MAIN))

;;; LaHaShem HaAretz U'Mloah
;;; Copyright 2013, 2014, and 2015 Purdue University. All rights reserved.

(include "QobiScheme.sch")
(include "toollib-c-macros.sch")
(include "sft.sch")
(c-include "sftlib-c.h")

(set! *program* "sft")
(set! *panic?* #f)

;;; Macros

;;; Structures

;;; Variables

;;; Parameters

;;; Procedures

;;; Commands

;;; Top Level

(define-application viewer 1600 950 #f 3 6
 (lambda ()
  (define-button 0 0 "Help" #f help-command)
  (define-button 1 0 "Delete" #f delete-command)
  (define-button 2 0 "Aravis" #f aravis-camera-command)
  (define-button 3 0 "V4L Camera" #f opencv-camera-command)
  (define-button 4 0 "Flag" #f flag-command)
  (define-button 5 0 "Quit" #f quit-command)
  (define undistort? (c-value bool "undistort"))
  ;; no keystroke
  (define-toggle-button 0 1 "Undistort"
   undistort?
   (lambda ()
    (message "")
    (c-value-set! bool "undistort" (not (c-value bool "undistort")))))
  ;; no keystroke
  (define-button 1 1 "Cal Und" #f calibrate-undistort-command)
  ;; no keystroke
  (define-button 2 1 "Save Parameters" #f save-parameters-command)
  (define-button 3 1 "Play" #f play-command)
  (define-button 4 1 "Capture" #f capture-command)
  (define-button 5 1 "Stop" #f stop-command)
  (define-button 0 2 "Previous" #f previous-command)
  (define-button 1 2 "Next" #f next-command)
  (define-button 2 2 "Previous Missing" #f previous-missing-command)
  (define-button 3 2 "Next Missing" #f next-missing-command)
  (define-button 4 2 "Previous Flagged" #f previous-flagged-command)
  (define-button 5 2 "Next Flagged" #f next-flagged-command)
  (define-key (control #\h) "Help" help-command)
  (define-key (control #\d) "Delete" delete-command)
  (define-key (control #\a) "Aravis" aravis-camera-command)
  (define-key (control #\v) "V4L Camera" opencv-camera-command)
  (define-key (control #\f) "Flag" flag-command)
  (define-key (list (control #\x) (control #\c)) "Quit" quit-command)
  (define-key #\p "Play" play-command)
  (define-key (control #\c) "Capture" capture-command)
  (define-key (control #\s) "Stop" stop-command)
  (define-key (control #\p) "Previous" previous-command)
  (define-key (control #\n) "Next" next-command)
  (define-key (meta #\p) "Previous Missing" previous-missing-command)
  (define-key (meta #\n) "Next Missing" next-missing-command)
  (define-key (control (meta #\p)) "Previous Flagged" previous-flagged-command)
  (define-key (control (meta #\n)) "Next Flagged" next-flagged-command)
  (report-next-to-film)
  (set! *stimuli-first-line* 0))
 (lambda () ((c-function void ("set_display_pane" int)) *display-pane*))
 (lambda () #f)
 (lambda ()
  (draw-stimuli-with-scroll-bar
   (lambda () *stimuli-first-line*)
   (lambda (first-line) (set! *stimuli-first-line* first-line))
   (lambda (i)
    (set! *i* i)
    (redraw-display-pane)
    (report-next-to-film))
   (lambda (i)
    (set! *i* i)
    (redraw-display-pane)
    (report-next-to-film))
   (lambda (i)
    (set! *i* i)
    (redraw-display-pane)
    (report-next-to-film))
   *stimuli*
   5 (- *display-pane-width* 10)
   605 (- *display-pane-height* 5))))

(define-command (main
		 (at-most-one ("window-position"
			       window-position?
			       (window-position-x "x" integer-argument 0)
			       (window-position-y "y" integer-argument 0)))
		 (at-most-one ("f" fps? (fps "fps" real-argument 15.0)))
		 (at-most-one
		  ("frames"
		   frames-to-save?
		   (frames-to-save "frames" integer-argument 150)))
                 (at-most-one ("undistort" undistort?))
                 (at-most-one ("parameters" parameters?
			       (parameters "pathname" string-argument "")))
		 (required (stimulus-directory "directory" string-argument))
		 (required (stimuli-pathname "pathname" string-argument)))
 (set! *stimulus-directory* stimulus-directory)
 (set! *stimuli-pathname* stimuli-pathname)
 (set! *window-position?* #f)
 (when window-position?
  (set! *window-position?* #t)
  (set! *window-position-x* window-position-x)
  (set! *window-position-y* window-position-y))
 (c-value-set! double "fps"  fps)
 (set! *fps* fps)
 (when frames-to-save?
  (c-value-set! unsigned "frames_to_save" frames-to-save))
 (when parameters?
  (set! *parameters* parameters)
  (let ((parameters (read-object-from-file parameters)))
   (for-each-indexed (lambda (x i)
		      (c-double-set! (c-value pointer "calibration")
				     (* (c-sizeof "double") i)
				     x))
		     (list-ref parameters 0))
   (for-each-indexed (lambda (x i)
		      (c-double-set! (c-value pointer "distortion")
				     (* (c-sizeof "double") i)
				     x))
		     (list-ref parameters 1))))
 (c-value-set! bool "undistort" undistort?)
 (set! *stimuli*
       (map (lambda (stimulus)
	     (make-stimulus
	      (first stimulus)
	      (second stimulus)
	      (file-exists?
	       (string-append stimulus-directory "/" (first stimulus)))
	      (third stimulus)))
	    (read-object-from-file stimuli-pathname)))
 (viewer '()))

;;; Tam V'Nishlam Shevah L'El Borei Olam
