;;; 128 possibilities if something must happen
;;; 191 possibilities if not

;;; if something must happen, and have 4 backgrounds, then have 512 stimuli
;;; 8 runs, 64 stimulus presentations per run, pairs of runs constitute folds
;;; a pair of runs has all possibilities

(define (actor1) (either 'dan 'scott #f))

(define (verb1) (either 'pick-up 'put-down #f))

(define (object1) (either 'briefcase 'chair #f))

(define (actor)
 (let ((actor (list (actor1) (actor1))))
  ;; no duplicate actors
  (when (and (first actor)
	     (second actor)
	     (eq? (first actor) (second actor)))
   (fail))
  actor))

;;; no before, simultaneous, after
;;; no hold, rest-on-ground when no verb

(define (verb)
 (let ((verb (list (verb1) (verb1))))
  ;; something must happen
  ;;(unless (or (first verb) (second verb)) (fail))
  verb))

(define (object) (list (object1) (object1)))

(define (sentence)
 (let ((actor (actor))
       (verb (verb))
       (object (object)))
  ;; verb requires actor and object
  (when (or (and (first verb) (or (not (first actor)) (not (first object))))
	    (and (second verb) (or (not (second actor)) (not (second object)))))
   (fail))
  (list actor verb object)))

(define *actors* '("nobody" "Dan" "Scott"))

(define *verbs* '("does nothing" "pick up" "put down"))

(define *objects* '("nothing" "briefcase" "chair"))

(define (leftify thing) (list thing "on left"))

(define (rightify thing) (list thing "on right"))

(define (no-duplicate-actors cross-product)
 (when (and (not (string=? (first (first cross-product)) "nobody"))
	    (not (string=? (first (fourth cross-product)) "nobody"))
	    (string=? (first (first cross-product))
		      (first (fourth cross-product))))
  (fail))
 cross-product)

(define (verb-requires-actor-and-object cross-product)
 (when (or (and (not (string=? (first (second cross-product)) "does nothing"))
		(or (string=? (first (first cross-product)) "nobody")
		    (string=? (first (third cross-product)) "nothing")))
	   (and (not (string=? (first (fifth cross-product)) "does nothing"))
		(or (string=? (first (fourth cross-product)) "nobody")
		    (string=? (first (sixth cross-product)) "nothing"))))
  (fail))
 cross-product)

(define (something-must-happen cross-product)
 (when (and (string=? (first (second cross-product)) "does nothing")
	    (string=? (first (fifth cross-product)) "does nothing"))
  (fail))
 cross-product)

(define *protoclasses*
 (all-values
  (something-must-happen
   (verb-requires-actor-and-object
    (no-duplicate-actors
     (nondeterministic-map
      a-member-of
      (list (map leftify *actors*)
	    (map leftify *verbs*)
	    (map leftify *objects*)
	    (map rightify *actors*)
	    (map rightify *verbs*)
	    (map rightify *objects*))))))))

(define (stringify strings)
 (reduce (lambda (s1 s2) (string-append s1 "-" s2))
	 (remove-if (lambda (s) (zero? (string-length s))) strings)
	 ""))

(define (spaces->hyphens string)
 (list->string
  (map (lambda (c) (if (char=? c #\space) #\- c)) (string->list string))))

(define (protoclass->filename protoclass)
 (string-append
  (stringify
   (map (lambda (element) (spaces->hyphens (first element)))
	(remove-if-not (lambda (element) (member "on left" element))
		       protoclass)))
  "-"
  (stringify
   (map (lambda (element) (spaces->hyphens (first element)))
	(remove-if-not (lambda (element) (member "on right" element))
		       protoclass)))))

(write-object-to-file
 (reduce
  append
  (vector->list
   (map-vector
    vector->list
    ;; The transposition is because it is easier to film all variants at once,
    ;; given that we are not changing shirts, chairs, and paper.
    (transpose
     (map-n-vector
      (lambda (i)
       (list->vector
	(map (lambda (protoclass)
	      (list (string-append (protoclass->filename protoclass)
				   "-"
				   (number->string i)
				   ".avi")
		    protoclass
		    #f))
	     *protoclasses*)))
      4))))
  '())
 "stimuli.sc")
