;;; This generates stimulus files for deconvolution for afni and fsl
;;;   it strips initial TRs and reformats

(define (generate-afni root experiment trs-to-drop seconds/tr)
 (let ((d (string*-append root "/" experiment "/afni/"))
       (drop (* trs-to-drop seconds/tr)))
  (rm d)
  (mkdir d)
  (for-each
   (lambda (f)
    (write-file
     (map (lambda (l)
	   (string*-join
	    " "
	    (map (lambda (a) (- (string->number a) drop))
		 ;; I don't know why there is a "*" field.
		 (remove "*" (fields l)))))
	  (read-file f))
     (string-append d "/" (strip-directory f))))
   (directory-list
    (string-append root "/" experiment "/" experiment ".??.1D")))))

(define (generate-fsl root experiment trs-to-drop seconds/tr)
 (let ((d (string*-append root "/" experiment "/fsl/"))
       (drop (* trs-to-drop seconds/tr)))
  (rm d)
  (mkdir d)
  (for-each
   (lambda (f)
    (let ((stimulus-id
	   (string->number (second (pregexp-split "\\." (strip-directory f))))))
     (for-each-indexed
      (lambda (l run)
       (let ((run (+ run 1)))
	(write-file
	 (map (lambda (a)
	       (string*-append (- (string->number a) drop) " " 2 " " 1))
	      ;; I don't know why there is a "*" field.
	      (remove "*" (fields l)))
	 (string*-append d "/" experiment stimulus-id "-run" run ".txt"))))
      (read-file f))))
   (directory-list
    (string-append root "/" experiment "/" experiment ".??.1D")))))

(define (generate-princeton-mvpa root experiment trs-to-drop trs/run)
 (let ((d (string*-append root "/" experiment "/princeton-mvpa/")))
  (rm d)
  (mkdir d)
  (start-matlab!)
  (scheme->matlab!
   "regs"
   (list->vector
    (map list->vector
         (map-n (lambda (n)
                 (let ((stimulus-id (+ n 1)))
                  (concat
                   (map (lambda (a) (drop trs-to-drop a))
                        (split-into-lists-of-n
                         (map string->number
                              (read-file
                               (string*-append root
					       "/"
					       experiment
					       "/"
					       experiment
					       "_"
					       stimulus-id
					       ".1D")))
                         trs/run)))))
		(length (directory-list
			 (string-append
			  root "/" experiment "/" experiment "_*.1D")))))))
  (matlab
   (format #f "save('~a/~a/princeton-mvpa/regs.mat','regs')" root experiment))
  (scheme->matlab!
   "runs"
   (vector
    (list->vector
     (concat
      (map-n (lambda (run) (map-n (lambda _ (+ run 1)) (- trs/run trs-to-drop)))
	     (length (split-into-lists-of-n
		      (read-file (string-append root
						"/"
						experiment
						"/"
						experiment
						"_1.1D"))
		      trs/run)))))))
  (matlab (format #f "save('~a/~a/princeton-mvpa/runs.mat','runs')"
		  root experiment))))

;; 0 is always rest/fixation
(define (generate-pymvpa root experiment trs-to-drop trs/run)
 (let ((d (string*-append root "/" experiment "/pymvpa/"))
       (classes (read-object-from-file
		 (string*-append root "/" experiment "/classes.sc"))))
  (rm d)
  (mkdir d)
  (write-file
   (map-indexed
    (lambda (l i)
     (format #f "~a ~a"
             (if (position 1 l)
                 (list-ref classes (position 1 l))
                 "rest")
             (quotient i (- trs/run trs-to-drop))))
    (unzip
     (map-n (lambda (n)
	     (let ((stimulus-id (+ n 1)))
	      (concat
	       (map (lambda (a) (drop trs-to-drop a))
		    (split-into-lists-of-n
		     (map string->number
			  (read-file (string*-append
				      root
				      "/"
				      experiment
				      "/"
				      experiment
				      "_"
				      stimulus-id
				      ".1D")))
		     trs/run)))))
	    (length (directory-list
		     (string-append
		      root "/" experiment "/" experiment "_*.1D"))))))
   (format #f "~a/~a/pymvpa/attributes" root experiment))))

(define (generate-pymvpa-hacked
	 root experiment trs-to-drop trs/run trs-to-offset)
 (let ((d (string*-append root "/" experiment "/pymvpa/"))
       (classes (read-object-from-file
		 (string*-append root "/" experiment "/classes.sc"))))
  (write-file
   (concat
    (map-indexed
     (lambda (l run)
      ;; assumes the first TR is always a fixation
      (map (lambda (l)
            (format #f "~a ~a"
                    (if (position 1 l)
                        (list-ref classes (position 1 l))
                        "rest")
                    run))
           (append
            (map-n (lambda _ (car l)) trs-to-offset)
            (reverse (drop trs-to-offset (reverse l))))))
     (split-into-lists-of-n
      (unzip
       (map-n (lambda (n)
               (let ((stimulus-id (+ n 1)))
                (concat
                 (map (lambda (a) (drop trs-to-drop a))
                      (split-into-lists-of-n
                       (map string->number
                            (read-file
                             (string*-append root
					     "/"
					     experiment
					     "/"
					     experiment
					     "_"
					     stimulus-id
					     ".1D")))
                       trs/run)))))
	      (length (directory-list
		       (string-append
			root "/" experiment "/" experiment "_*.1D")))))
      (- trs/run trs-to-drop))))
   (format #f "~a/~a/pymvpa/attributes-hacked-~a"
	   root experiment trs-to-offset))))

(define *spread* 1)
(define *experiments*
 '("actor-verb-object-on-left-from-video"
   "actor-verb-object-on-left-from-text"
   "actor-verb-object-on-left-from-both"
   "actor-verb-object-on-left-modality"
   "actor-verb-object-on-right-from-video"
   "actor-verb-object-on-right-from-text"
   "actor-verb-object-on-right-from-both"
   "actor-verb-object-on-right-modality"
   "verb-object-on-left-from-video"
   "verb-object-on-left-from-text"
   "verb-object-on-left-from-both"
   "verb-object-on-left-modality"
   "verb-object-on-right-from-video"
   "verb-object-on-right-from-text"
   "verb-object-on-right-from-both"
   "verb-object-on-right-modality"
   "actor-object-on-left-from-video"
   "actor-object-on-left-from-text"
   "actor-object-on-left-from-both"
   "actor-object-on-left-modality"
   "actor-object-on-right-from-video"
   "actor-object-on-right-from-text"
   "actor-object-on-right-from-both"
   "actor-object-on-right-modality"
   "object-on-left-from-video"
   "object-on-left-from-text"
   "object-on-left-from-both"
   "object-on-left-modality"
   "object-on-right-from-video"
   "object-on-right-from-text"
   "object-on-right-from-both"
   "object-on-right-modality"
   "actor-verb-on-left-from-video"
   "actor-verb-on-left-from-text"
   "actor-verb-on-left-from-both"
   "actor-verb-on-left-modality"
   "actor-verb-on-right-from-video"
   "actor-verb-on-right-from-text"
   "actor-verb-on-right-from-both"
   "actor-verb-on-right-modality"
   "verb-on-left-from-video"
   "verb-on-left-from-text"
   "verb-on-left-from-both"
   "verb-on-left-modality"
   "verb-on-right-from-video"
   "verb-on-right-from-text"
   "verb-on-right-from-both"
   "verb-on-right-modality"
   "actor-on-left-from-video"
   "actor-on-left-from-text"
   "actor-on-left-from-both"
   "actor-on-left-modality"
   "actor-on-right-from-video"
   "actor-on-right-from-text"
   "actor-on-right-from-both"
   "actor-on-right-modality"
   "modality"
   "raw"))
(define *trs-to-drop* (* 2 *spread*))
(define *trs/run* (* 254 *spread*))
(define *seconds/tr* (/ 2.0 *spread*))
(define *root* "generated-experiments")
(define *number-of-subjects* 13)

(for-each-n
 (lambda (subject)
  (let ((root
	  (string-append *root*
			 "/subject-"
			 (number->padded-string-of-length (+ subject 1) 2))))
   (for-each
    (lambda (experiment)
     (generate-afni root experiment *trs-to-drop* *seconds/tr*)
     (generate-fsl root experiment *trs-to-drop* *seconds/tr*)
     ;; we don't use this anymore
     (when #f
      (generate-princeton-mvpa root experiment *trs-to-drop* *trs/run*))
     (generate-pymvpa root experiment *trs-to-drop* *trs/run*)
     (generate-pymvpa-hacked
      root experiment *trs-to-drop* *trs/run* (* 1 *spread*))
     (generate-pymvpa-hacked
      root experiment *trs-to-drop* *trs/run* (* 2 *spread*))
     (generate-pymvpa-hacked
      root experiment *trs-to-drop* *trs/run* (* 3 *spread*))
     (generate-pymvpa-hacked
      root experiment *trs-to-drop* *trs/run* (* 4 *spread*)))
    *experiments*)))
 *number-of-subjects*)
