(MODULE SFTLIB-SC)

;;; LaHaShem HaAretz U'Mloah
;;; Copyright 2012, 2013, 2014, and 2015 Purdue University. All rights reserved.

(include "QobiScheme.sch")
(include "toollib-c-macros.sch")
(include "sftlib-sc.sch")
(c-include "sftlib-c.h")

;;; Macros

;;; Structures

(define-structure stimulus pathname classes exists? flagged?)

;;; Variables

(define *fps* #f)

(define *parameters* #f)

(define *stimuli* #f)

(define *stimuli-first-line* #f)

(define *i* 0)

(define *stimulus-directory* #f)

(define *stimuli-pathname* #f)

;;; Parameters

;;; Procedures

(define (report-next-to-film)
 (message
  (format #f "~s/~s~a ~a"
	  (+ *i* 1)
	  (length *stimuli*)
	  (if (stimulus-exists? (list-ref *stimuli* *i*))
	      (if (stimulus-flagged? (list-ref *stimuli* *i*))
		  ", flagged:"
		  ":")
	      (if (stimulus-flagged? (list-ref *stimuli* *i*))
		  ", missing, flagged:"
		  ", missing:"))
	  (strip-extension (stimulus-pathname (list-ref *stimuli* *i*))))))

(define (update-scroll-bar!)
 (let* ((ymin 605)
	(ymax (- *display-pane-height* 5))
	(visible-lines (quotient (- ymax ymin) *roman-height*))
	(first-line *stimuli-first-line*)
	(last-line (min (+ first-line visible-lines) (length *stimuli*))))
  (cond ((< *i* first-line) (set! *stimuli-first-line* *i*))
	((>= *i* last-line) (set! *stimuli-first-line* *i*))))
 (redraw-display-pane)
 (report-next-to-film))

(define (draw-stimuli-with-scroll-bar
	 first-line set-first-line!
	 left middle right stimuli
	 xmin xmax ymin ymax)
 (let* ((visible-lines (quotient (- ymax ymin) *roman-height*))
	(first-line (first-line))
	(last-line (min (+ first-line visible-lines) (length stimuli))))
  (unless (null? stimuli)
   (let* ((y1 ymin)
	  (y2 ymax)
	  (y3 (+ y1
		 (inexact->exact
		  (floor (* (- y2 y1) (/ first-line (length stimuli)))))))
	  (y4 (+ y1
		 (inexact->exact
		  (floor (* (- y2 y1) (/ last-line (length stimuli))))))))
    (xfillrectangle
     *display* *display-pane* *thin-gc* (+ xmax 4) y1 1 (- y2 y1))
    (xfillrectangle
     *display* *display-pane* *thin-gc* (+ xmax 2) y3 5 (- y4 y3))
    (define-region
     (+ xmax 2)
     y1
     5
     (- y2 y1)
     (lambda (x y)
      (set-first-line!
       (min (max 0 (- (length stimuli) visible-lines))
	    (quotient (* (length stimuli) (- y y1)) (- y2 y1))))
      (redraw-display-pane)))
    (define-region
     (+ xmax 2)
     y3
     5
     (- y4 y3)
     (lambda (x y5)
      (tracking-pointer
       #f
       #f
       (lambda (x y6)
	(set-first-line!
	 (min (max 0 (- (length stimuli) visible-lines))
	      (max 0
		   (+ first-line
		      (quotient (* (length stimuli) (- y6 y5)) (- y2 y1))))))
	(redraw-display-pane)))))))
  (let ((n (string-length (number->string (length stimuli)))))
   (for-each-indexed
    (lambda (stimulus i)
     (let ((string
	    (format #f "~a~a: ~a"
		    (if (stimulus-exists? stimulus)
			(if (stimulus-flagged? stimulus)
			    "        flagged "
			    "                ")
			(if (stimulus-flagged? stimulus)
			    "missing flagged "
			    "missing         "))
		    (number->string-of-length (+ i first-line 1) n)
		    (strip-extension (stimulus-pathname stimulus)))))
      (define-button-specific-region
       button1
       0
       0
       xmin
       (+ (* i *roman-height*) ymin)
       (xtextwidth *roman-font* string (string-length string))
       *roman-height*
       (lambda (x y) (left (+ i first-line))))
      (define-button-specific-region
       button2
       0
       0
       xmin
       (+ (* i *roman-height*) ymin)
       (xtextwidth *roman-font* string (string-length string))
       *roman-height*
       (lambda (x y) (middle (+ i first-line))))
      (define-button-specific-region
       button3
       0
       0
       xmin
       (+ (* i *roman-height*) ymin)
       (xtextwidth *roman-font* string (string-length string))
       *roman-height*
       (lambda (x y) (right (+ i first-line))))
      (xdrawstring *display* *display-pane*
		   (if (= (+ i first-line) *i*) *bold-gc* *roman-gc*)
		   xmin (+ (* (+ i 1) *roman-height*) ymin)
		   string (string-length string))))
    (sublist stimuli first-line last-line)))))

;;; Detections

;;; Commands

(define (aravis-camera-command)
 (message "")
 ((c-function void ("stop_threads")))
 ((c-function void ("set_source" unsigned)) 0)
 ((c-function void ("start_threads")))
 (redraw-display-pane)
 (report-next-to-film))

(define (opencv-camera-command)
 (message "")
 ((c-function void ("stop_threads")))
 ((c-function void ("set_source" unsigned)) 1)
 ((c-function void ("start_threads")))
 (redraw-display-pane)
 (report-next-to-film))

(define (stop-command)
 (message "")
 ((c-function void ("stop_threads")))
 (redraw-display-pane)
 (report-next-to-film))

(define (quit-command)
 (message "")
 (stop-command)
 (quit))

(define (calibrate-undistort-command)
 ;; needs work: This is broken because we ripped out saved frames.
 (message "Failed to calibrate"))

(define (save-parameters-command)
 (message "")
 (unless *parameters* (message "Must calibrate first") (abort))
 (write-object-to-file
  (list (map-n (lambda (i)
		(c-double-ref (c-value pointer "calibration")
			      (* (c-sizeof "double") i)))
	       9)
	(map-n (lambda (i)
		(c-double-ref (c-value pointer "distortion")
			      (* (c-sizeof "double") i)))
	       5))
  *parameters*))

(define (play-command)
 (message "")
 (unless (c-value bool "running") (message "Camera must be running") (abort))
 (unless (stimulus-exists? (list-ref *stimuli* *i*))
  (message "Missing")
  (abort))
 ((c-function void ("playback" string))
  (string-append
   *stimulus-directory* "/" (stimulus-pathname (list-ref *stimuli* *i*))))
 (let loop ()
  (when (or (c-value bool "start_playback")
	    (c-value bool "playback_running"))
   (usleep 100000)
   (loop)))
 (set! *i* (min (+ *i* 1) (- (length *stimuli*) 1)))
 (update-scroll-bar!))

(define (capture-command)
 (message "")
 (unless (c-value bool "running") (message "Camera must be running") (abort))
 (when (stimulus-exists? (list-ref *stimuli* *i*))
  (message "Delete first")
  (abort))
 (usleep (* 4 1000000))
 ;; This is the protocol in ~/howard/source/capture-tool.sc and
 ;; ~/howard/source/srtg.sc.
 ;; The protocol in ~/howard/source/leonard.sc, ~/howard/source/howard.sc,
 ;; and ~/howard/source/mjs.sc is two beeps to start and one beep to end.
 (system "xkbbell")
 (usleep 1000000)
 (system "xkbbell")
 (usleep 1000000)
 (system "xkbbell")
 (usleep 1000000)
 (system "xkbbell")
 (usleep 250000)
 (system "xkbbell")
 ((c-function void ("write_saved_frames" string))
  (string-append
   *stimulus-directory* "/" (stimulus-pathname (list-ref *stimuli* *i*))))
 (let loop ()
  (when (or (c-value bool "start_saving_frames")
	    (c-value bool "saving_frames"))
   (usleep (* 1 1000000)) (loop)))
 (system "xkbbell")
 (set-stimulus-exists?! (list-ref *stimuli* *i*) #t)
 ((c-function void ("playback" string))
  (string-append
   *stimulus-directory* "/" (stimulus-pathname (list-ref *stimuli* *i*))))
 (let loop ()
  (when (or (c-value bool "start_playback")
	    (c-value bool "playback_running"))
   (usleep 100000)
   (loop)))
 (set! *i* (min (+ *i* 1) (- (length *stimuli*) 1)))
 (update-scroll-bar!))

(define (previous-command)
 (message "")
 (when (zero? *i*) (message "At beginning") (abort))
 (set! *i* (- *i* 1))
 (update-scroll-bar!))

(define (next-command)
 (message "")
 (when (= *i* (- (length *stimuli*) 1)) (message "At end") (abort))
 (set! *i* (+ *i* 1))
 (update-scroll-bar!))

(define (previous-missing-command)
 (message "")
 (when (zero? *i*) (message "At beginning") (abort))
 (set! *i* (- *i* 1))
 (let loop ()
  (unless (or (zero? *i*) (not (stimulus-exists? (list-ref *stimuli* *i*))))
   (set! *i* (- *i* 1))
   (loop)))
 (update-scroll-bar!))

(define (next-missing-command)
 (message "")
 (when (= *i* (- (length *stimuli*) 1)) (message "At end") (abort))
 (set! *i* (+ *i* 1))
 (let loop ()
  (unless (or (= *i* (- (length *stimuli*) 1))
	      (not (stimulus-exists? (list-ref *stimuli* *i*))))
   (set! *i* (+ *i* 1))
   (loop)))
 (update-scroll-bar!))

(define (previous-flagged-command)
 (message "")
 (when (zero? *i*) (message "At beginning") (abort))
 (set! *i* (- *i* 1))
 (let loop ()
  (unless (or (zero? *i*) (stimulus-flagged? (list-ref *stimuli* *i*)))
   (set! *i* (- *i* 1))
   (loop)))
 (update-scroll-bar!))

(define (next-flagged-command)
 (message "")
 (when (= *i* (- (length *stimuli*) 1)) (message "At end") (abort))
 (set! *i* (+ *i* 1))
 (let loop ()
  (unless (or (= *i* (- (length *stimuli*) 1))
	      (stimulus-flagged? (list-ref *stimuli* *i*)))
   (set! *i* (+ *i* 1))
   (loop)))
 (update-scroll-bar!))

(define (delete-command)
 (message "")
 (when (stimulus-exists? (list-ref *stimuli* *i*))
  (set-stimulus-exists?! (list-ref *stimuli* *i*) #f)
  (rm
   (string-append
    *stimulus-directory* "/" (stimulus-pathname (list-ref *stimuli* *i*)))))
 (redraw-display-pane)
 (report-next-to-film))

(define (flag-command)
 (message "")
 (set-stimulus-flagged?! (list-ref *stimuli* *i*)
			 (not (stimulus-flagged? (list-ref *stimuli* *i*))))
 (write-object-to-file
  (map (lambda (stimulus)
	(list (stimulus-pathname stimulus)
	      (stimulus-classes stimulus)
	      (stimulus-flagged? stimulus)))
       *stimuli*)
  *stimuli-pathname*)
 (redraw-display-pane)
 (report-next-to-film))

;;; Tam V'Nishlam Shevah L'El Borei Olam
