import matplotlib.pyplot as plt

x = [32, 64, 96, 128, 160, 192, 224, 256, 288, 320, 352, 384, 416, 448, 480, 512, 544, 576, 608, 640, 672, 704, 736, 768, 800, 832, 864, 896, 928, 960, 992, 1024, 1056, 1088, 1120, 1152, 1184, 1216, 1248, 1280, 1312, 1344, 1376, 1408, 1440, 1472, 1504, 1536, 1568, 1600, 1632, 1664, 1696, 1728, 1760, 1792, 1824, 1856, 1888, 1920, 1952, 1984, 2016, 2048]


# Largest Shape

# 28672, 4096
y1_baseline = [
91.04,
92.13,
94.94,
95.07,
120.03,
117.44,
121.22,
120.38,
156.93,
157.22,
157.54,
158.59,
194.88,
183.07,
182.91,
185.57,
234.18,
236,
234.24,
230.27,
253.82,
254.75,
255.78,
258.34,
294.78,
296.45,
293.82,
293.28,
323.74,
321.06,
323.62,
327.07,
384.86,
382.85,
377.82,
379.26,
409.66,
410.56,
411.17,
414.66,
465.38,
462.69,
467.07,
465.38,
482.62,
484.32,
487.62,
488.19,
536.54,
536.03,
536.96,
540.96,
551.33,
550.46,
553.22,
553.18,
614.69,
618.91,
615.52,
618.08,
635.78,
640.16,
641.89,
643.81
]  
  
  
y1_custom = [
93.98,
94.91,
98.53,
98.53,
122.43,
121.7,
122.69,
123.84,
177.25,
180,
180.26,
180.42,
188.42,
188.03,
190.5,
191.52,
256.51,
257.79,
260,
262.08,
263.81,
264.86,
267.17,
269.12,
328.06,
330.08,
332.29,
333.73,
335.2,
337.15,
337.12,
340.22,
417.5,
417.15,
419.81,
422.69,
425.76,
427.87,
429.41,
434.02,
488.93,
491.81,
493.79,
497.73,
498.85,
501.06,
505.15,
506.75,
559.23,
560.35,
563.23,
564.45,
567.81,
568.86,
571.65,
574.14,
652.64,
652.1,
654.11,
655.65,
658.08,
660.74,
663.74,
667.71
]


# 28672, 5120
y2_baseline = [
101.89,
104.22,
107.49,
108.58,
141.15,
138.46,
139.78,
141.92,
186.82,
189.66,
190.24,
190.18,
238.53,
225.95,
222.82,
223.97,
291.78,
292.96,
286.59,
284.99,
313.02,
307.87,
308.61,
309.44,
364.51,
367.84,
362.98,
363.23,
407.14,
401.25,
406.08,
407.52,
473.7,
473.76,
474.5,
475.46,
506.59,
509.28,
511.87,
513.06,
582.43,
583.39,
579.9,
583.84,
596.32,
599.58,
601.6,
604.03,
670.91,
658.59,
658.24,
659.9,
689.98,
693.6,
697.95,
699.55,
767.97,
770.21,
770.59,
775.23,
791.97,
794.85,
799.04,
802.5
]
  
y2_custom = [
107.14,
110.05,
116.03,
114.94,
142.27,
143.81,
144.03,
145.38,
213.6,
214.62,
217.12,
219.07,
227.3,
229.89,
231.87,
234.14,
308.86,
311.04,
313.44,
314.75,
318.11,
323.39,
322.94,
326.24,
405.34,
406.56,
411.78,
414.46,
416.1,
419.39,
421.76,
423.87,
519.62,
522.08,
525.02,
528.77,
531.71,
533.18,
537.41,
538.4,
614.05,
616.61,
621.47,
622.34,
625.22,
628.58,
631.39,
631.71,
708.99,
709.18,
713.12,
717.38,
719.36,
719.52,
723.74,
727.52,
817.02,
819.65,
824.8,
825.41,
828.93,
830.14,
836.13,
836.13
]


# 35840, 5120
y3_baseline = [
131.94,
136.93,
150.21,
149.18,
184.19,
177.02,
180.16,
181.41,
227.58,
230.18,
230.24,
228,
294.08,
279.46,
270.11,
274.75,
360.45,
360.83,
360,
357.38,
390.4,
381.02,
384.77,
388.1,
482.88,
484.67,
478.53,
476.86,
518.75,
507.58,
511.94,
514.59,
600.35,
587.84,
590.02,
589.57,
617.34,
619.39,
623.97,
626.69,
687.71,
701.12,
702.78,
703.23,
731.49,
734.43,
737.98,
740.35,
816.13,
818.72,
820.8,
823.74,
847.07,
851.68,
853.18,
858.21,
942.21,
940.32,
942.27,
947.23,
962.24,
964.96,
969.02,
971.84
]
y3_custom = [
137.63,
146.85,
158.02,
157.44,
178.85,
179.3,
179.81,
181.7,
256.1,
255.71,
259.36,
262.5,
275.23,
277.7,
281.31,
282.37,
382.78,
388.38,
390.27,
392.67,
395.42,
397.92,
401.28,
405.02,
512.38,
515.36,
518.53,
523.1,
526.08,
528.96,
531.42,
535.04,
632.45,
624.54,
627.58,
631.17,
635.42,
638.88,
644.38,
649.28,
734.98,
739.97,
743.55,
746.78,
752.29,
755.52,
759.68,
762.18,
866.3,
857.31,
860.32,
862.08,
868.06,
873.06,
880.1,
882.24,
969.28,
972.35,
978.21,
982.59,
990.85,
995.33,
999.14,
1000
]

# 65536, 5120
y4_baseline = [
229.31,
231.81,
240.54,
241.22,
296.22,
288.74,
291.62,
300.16,
380.22,
385.28,
385.15,
384.96,
501.79,
481.57,
468.1,
477.25,
608.93,
612.29,
605.47,
605.18,
683.55,
677.95,
685.95,
689.09,
843.1,
848.9,
837.15,
837.76,
913.7,
900.42,
905.54,
912.38,
1110,
1090,
1060,
1060,
1110,
1120,
1130,
1130,
1280,
1280,
1290,
1300,
1320,
1330,
1340,
1350,
1520,
1530,
1530,
1520,
1550,
1550,
1560,
1580,
1730,
1760,
1740,
1750,
1770,
1780,
1790,
1800
]
y4_custom = [
234.59,
246.11,
252.93,
253.89,
298.88,
299.97,
301.28,
302.18,
433.76,
437.73,
441.57,
445.73,
485.73,
488.58,
493.79,
495.17,
689.18,
695.52,
700.8,
704.86,
711.33,
714.78,
723.1,
726.62,
912.83,
919.14,
924.96,
929.12,
935.42,
944.29,
947.58,
950.91,
1140,
1140,
1150,
1160,
1170,
1170,
1180,
1190,
1360,
1370,
1380,
1380,
1390,
1400,
1410,
1420,
1590,
1600,
1610,
1620,
1630,
1640,
1660,
1660,
1820,
1830,
1840,
1860,
1870,
1880,
1890,
1890
]

y_before_simt = [235.65, 245.22, 267.2, 267.33, 317.82, 316.8, 317.89, 319.71, 495.74, 499.68, 498.34, 498.82, 581.12, 579.74, 579.58, 583.49, 589.7, 586.62, 589.28, 587.23, 592.45, 592.86, 590.27, 591.01, 941.86, 938.85, 941.06, 942.94, 947.14, 945.47, 944.48, 951.81, 1170, 1160, 1170, 1160, 1160, 1170, 1170, 1170, 1170, 1160, 1160, 1160, 1170, 1170, 1170, 1170, 1580, 1570, 1580, 1580, 1590, 1580, 1580, 1580, 1590, 1600, 1590, 1600, 1600, 1590, 1590, 1590]
y_after_simt = [123.42, 127.87, 145.7, 146.69, 201.38, 202.46, 221.25, 223.3, 245.44, 247.26, 251.36, 253.66, 332.45, 333.44, 333.25, 338.11, 344.8, 347.94, 350.4, 352.9, 354.53, 358.34, 359.84, 363.68, 664.9, 665.57, 668.32, 670.02, 670.24, 675.71, 678.21, 683.17, 667.74, 672.03, 673.15, 676.03, 677.76, 680.29, 680.86, 683.81, 709.41, 712.32, 715.94, 717.54, 720.26, 725.34, 725.95, 728.35, 960.13, 962.11, 967.81, 968.26, 1040, 1040, 1050, 1050, 1030, 1030, 1040, 1040, 1040, 1050, 1050, 1050]
y_final = [120.9, 128.77, 148.61, 149.38, 179.01, 180.58, 182.37, 185.12, 228.9, 229.18, 231.62, 232.74, 251.01, 253.5, 253.06, 256.61, 331.84, 334.27, 337.89, 338.85, 341.54, 343.97, 346.94, 350.43, 460.8, 464.38, 467.2, 469.44, 472.99, 474.72, 478.02, 477.5, 635.81, 637.76, 640.1, 642.85, 668.54, 669.63, 671.49, 672.1, 689.38, 690.5, 696.03, 699.04, 701.47, 703.14, 706.69, 711.55, 788.32, 792.74, 795.36, 797.28, 800.9, 805.57, 810.82, 812.19, 977.79, 977.95, 983.04, 985.06, 991.65, 993.09, 996.1, 1000]

fig, axes = plt.subplots(1, 5, figsize=(30, 6))  # 2x2 layout
axes = axes.flatten()  # flatten to use axes[0] to axes[3] as before

lines = []

lines += axes[0].plot(x, y1_baseline, marker='o', markersize=4, color='darkred', label='CUTLASS Baseline W16A16')
lines += axes[0].plot(x, y1_custom, marker='o', markersize=4, color='#009E73', label='NestedFP16')
lines += axes[1].plot(x, y2_baseline, marker='o', markersize=4, color='darkred', label='CUTLASS Baseline W16A16')
lines += axes[1].plot(x, y2_custom, marker='o', markersize=4, color='#009E73', label='NestedFP16')
lines += axes[2].plot(x, y3_baseline, marker='o', markersize=4, color='darkred', label='CUTLASS Baseline W16A16')
lines += axes[2].plot(x, y3_custom, marker='o', markersize=4, color='#009E73', label='NestedFP16')
lines += axes[3].plot(x, y4_baseline, marker='o', markersize=4, color='darkred', label='CUTLASS Baseline W16A16')
lines += axes[3].plot(x, y4_custom, marker='o', markersize=4, color='#009E73', label='NestedFP16')

lines += axes[4].plot(x, y_before_simt, marker='o', markersize=4, color='blue', label='Lvl 1')
lines += axes[4].plot(x, y_after_simt, marker='o', markersize=4, color='orange', label='Lvl 2')
lines += axes[4].plot(x, y_final, marker='o', markersize=4, color='gray', label='Lvl 3')

# Y-axis label only on left column
axes[0].set_ylabel("Latency (us)", fontsize=28, labelpad=8)

axes[4].set_ylabel("Latency (us)", fontsize=28, labelpad=8)
#axes[2].set_ylabel("Latency (us)", fontsize=14, labelpad=8)

# X-axis label only on bottom row
axes[0].set_xlabel("M", fontsize=28, labelpad=8)
axes[1].set_xlabel("M", fontsize=28, labelpad=8)
axes[2].set_xlabel("M", fontsize=28, labelpad=8)
axes[3].set_xlabel("M", fontsize=28, labelpad=8)
axes[4].set_xlabel("M", fontsize=28, labelpad=8)
# ax.text(0.5, -0.2, title, transform=ax.transAxes, fontsize=16, ha='center', va='top')

# Phi-4
#titles = ["N = 5120, K = 5120", "N = 5120, K = 17920", "N = 7680, K = 5120", "N = 35840, K = 5120"]

# Mistral Small
#titles = ["N = 5120, K = 4096", "N = 5120, K = 32768", "N = 6144, K = 5120", "N = 65536, K = 5120"]

# Mistral Nemo
#titles = ["N = 5120, K = 4096", "N = 5120, K = 14336", "N = 6144, K = 5120", "N = 28672, K = 5120"]

# Llama 3.1 8B
#titles = ["N = 4096, K = 4096", "N = 6144, K = 4096", "N = 28672, K = 4096", "N = 4096, K = 14336"]

# Biggest Shape
titles = ["N = 28672, K = 4096", "N = 28672, K = 5120", "N = 35840, K = 5120", "N = 65536, K = 5120"]

for ax, title in zip(axes[:4], titles):
    ax.text(0.5, -0.3, title, transform=ax.transAxes, fontsize=32, ha='center', va='top')
    ax.tick_params(axis='x', labelsize=28)
    ax.tick_params(axis='y', labelsize=28)
    ax.grid(axis='y', linestyle='--', alpha=0.5)
    ax.set_xlim(0, 2080)

labels = [line.get_label() for line in lines][:2]

legend = fig.legend(lines, labels, loc='upper center', ncol=2, fontsize=32, bbox_to_anchor=(0.4, 1.05))
legend.set_frame_on(False)

axes[4].tick_params(axis='x', labelsize=28)
axes[4].tick_params(axis='y', labelsize=28)
axes[4].grid(axis='y', linestyle='--', alpha=0.5)
axes[4].set_xlim(0, 2080)
#axes[4].legend(loc='upper left')
legend = axes[4].legend(loc='upper center', ncol=3, fontsize=26, columnspacing=0.8, bbox_to_anchor=(0.5, 1.23))
legend.set_frame_on(False)


plt.tight_layout()
plt.subplots_adjust(top=0.88)
plt.subplots_adjust(hspace=0.8)
plt.savefig("kernel_performance.pdf", dpi=400)
