// This file was automatically generated by the CUTLASS 3.5.1 Python interface (https://github.com/nvidia/cutlass/python)

#include <cuda_runtime.h>
#include <torch/extension.h>
#include <ATen/ATen.h>
#include <ATen/cuda/CUDAContext.h>
#include "cutlass/cutlass.h"
#include "cutlass/util/device_memory.h"

#include "cutlass/gemm/device/gemm_universal_adapter.h"
#include "cutlass/gemm/collective/collective_builder.hpp"
#include "cutlass/gemm/device/gemm_universal_adapter.h"
#include "cutlass/gemm/kernel/gemm_universal.hpp"
#include "cutlass/epilogue/collective/collective_builder.hpp"
#include "cutlass/util/packed_stride.hpp"

using MainloopScheduleType = cutlass::gemm::KernelTmaWarpSpecializedCooperativeMixedInput;
using EpilogueScheduleType = cutlass::epilogue::TmaWarpSpecializedCooperative;
using TileSchedulerType = cutlass::gemm::PersistentScheduler;

using namespace cute;

template<int T1, int T2, int T3, int C1, int C2, int C3>
at::Tensor cutlass_tma_warp_specialized_cooperative_mixed_kernel(const at::Tensor& A, const at::Tensor& B) {
    at::optional<const at::Tensor> C=at::nullopt;
    float alpha=1.f;
    float beta=0.f;

    using CollectiveEpilogue =
        typename cutlass::epilogue::collective::CollectiveBuilder<
            cutlass::arch::Sm90, cutlass::arch::OpClassTensorOp,
            cute::Shape<cute::Int<T1>, cute::Int<T2>, cute::Int<T3>>,
            cute::Shape<cute::_1, cute::_1, cute::_1>,
            cutlass::epilogue::collective::EpilogueTileAuto,
            float, float,
            cutlass::half_t, cutlass::layout::ColumnMajor, 8,
            cutlass::half_t, cutlass::layout::ColumnMajor, 8,
            EpilogueScheduleType
        >::CollectiveOp;

    using CollectiveMainloop =
        typename cutlass::gemm::collective::CollectiveBuilder<
            cutlass::arch::Sm90, cutlass::arch::OpClassTensorOp,
            cutlass::half_t, cutlass::layout::RowMajor, 8,
            cutlass::float_e4m3_t, cutlass::layout::ColumnMajor, 16,
            float,
            cute::Shape<cute::Int<T1>, cute::Int<T2>, cute::Int<T3>>,
            cute::Shape<cute::Int<C1>, cute::Int<C2>, cute::Int<C3>>,
            cutlass::gemm::collective::StageCountAutoCarveout<static_cast<int>(sizeof(typename CollectiveEpilogue::SharedStorage))>,
            MainloopScheduleType
        >::CollectiveOp;

    using GemmKernel = cutlass::gemm::kernel::GemmUniversal<
        Shape<int,int,int,int>,
        CollectiveMainloop,
        CollectiveEpilogue,
        TileSchedulerType
    >;

    // Define device-level operator
    using DeviceKernel = cutlass::gemm::device::GemmUniversalAdapter<GemmKernel>;

    using StrideA = typename DeviceKernel::GemmKernel::StrideA;
    using StrideB = typename DeviceKernel::GemmKernel::StrideB;
    using StrideC = typename DeviceKernel::GemmKernel::StrideC;
    using StrideD = typename DeviceKernel::GemmKernel::StrideD;

    using ElementCompute = typename DeviceKernel::EpilogueOutputOp::ElementCompute;

    bool hw_info_queried = false;
    cutlass::KernelHardwareInfo hw_info;
  
    int M = A.size(0);
    int N = B.size(0);
    int K = A.size(1);
    int L = 1;
  
    // Query hardware info if we haven't already
    if (!hw_info_queried) {
        hw_info.device_id = 0;
        hw_info.sm_count = cutlass::KernelHardwareInfo::query_device_multiprocessor_count(hw_info.device_id);
    }

    typename DeviceKernel::ElementC* ptrC = (C == at::nullopt) ?
                                            nullptr :
                                            reinterpret_cast<typename DeviceKernel::ElementC*>(C->contiguous().data_ptr());
    at::Tensor D = B.new_empty({M, N}, torch::kF16);

    const cutlass::half_t* A_ = reinterpret_cast<typename DeviceKernel::ElementA*>(A.contiguous().data_ptr());
    const cutlass::float_e4m3_t* B_ = reinterpret_cast<typename DeviceKernel::ElementB*>(B.contiguous().data_ptr());
    const cutlass::half_t* C_ = nullptr;
    cutlass::half_t* D_ = reinterpret_cast<typename DeviceKernel::ElementC*>(D.contiguous().data_ptr());
    ElementCompute alpha_ = ElementCompute(alpha);
    ElementCompute beta_ = ElementCompute(beta);

    typename DeviceKernel::Arguments arguments{
        cutlass::gemm::GemmUniversalMode::kGemm,
        {M, N, K, L}, // problem size
        {
            A_, // ptrA
            cutlass::make_cute_packed_stride(StrideA{}, cute::make_shape(M, K, L)), // stride A
            B_, // ptrB
            cutlass::make_cute_packed_stride(StrideB{}, cute::make_shape(N, K, L)), // stride B
        },
        {
            {alpha_, beta_},
            C_, // ptrC
            cutlass::make_cute_packed_stride(StrideC{}, cute::make_shape(M, N, L)), // stride C
            D_, // ptrD
            cutlass::make_cute_packed_stride(StrideD{}, cute::make_shape(M, N, L)), // stride D
        },
        hw_info
    };

    size_t workspace_size = DeviceKernel::get_workspace_size(arguments);
    cutlass::device_memory::allocation<uint8_t> workspace(workspace_size);

    DeviceKernel gemm_op;
    cutlass::Status status = gemm_op.run(arguments,
                                        workspace.get(),
                                        nullptr); // CUDA stream

    TORCH_CHECK(status == cutlass::Status::kSuccess, "CUTLASS kernel failed");
    return D;
}
