# This file was automatically generated by the CUTLASS 3.5.1 Python interface (https://github.com/nvidia/cutlass/python)

from setuptools import setup
from torch.utils.cpp_extension import BuildExtension, CUDAExtension

setup(
    name='cutlass',
    ext_modules=[
        CUDAExtension('cutlass', [
            'cutlass.cpp',
            'cutlass_tma_warp_specialized_kernel.cu',
            'cutlass_tma_warp_specialized_cooperative_kernel.cu',
            'cutlass_tma_warp_specialized_cooperative_streamk_kernel.cu',
            'cutlass_tma_warp_specialized_custom_kernel.cu',
            'cutlass_tma_warp_specialized_cooperative_custom_kernel.cu',
            'cutlass_tma_warp_specialized_cooperative_streamk_custom_kernel.cu',
            'cutlass_tma_warp_specialized_custom_2_stage_kernel.cu',
            'cutlass_tma_warp_specialized_custom_3_stage_kernel.cu',
            'cutlass_tma_warp_specialized_cooperative_custom_2_stage_kernel.cu',
            'cutlass_tma_warp_specialized_cooperative_custom_3_stage_kernel.cu',
            'cutlass_tma_warp_specialized_cooperative_streamk_custom_2_stage_kernel.cu',
            'cutlass_tma_warp_specialized_cooperative_streamk_custom_3_stage_kernel.cu',
            'cutlass_tma_warp_specialized_custom_3_stage_naive_simt_kernel.cu',
            'cutlass_tma_warp_specialized_cooperative_custom_3_stage_naive_simt_kernel.cu',
            'cutlass_tma_warp_specialized_cooperative_streamk_custom_3_stage_naive_simt_kernel.cu',
            'cutlass_tma_warp_specialized_fp8_kernel.cu',
            'cutlass_tma_warp_specialized_cooperative_fp8_kernel.cu',
            'cutlass_tma_warp_specialized_mixed_kernel.cu',
            'cutlass_tma_warp_specialized_cooperative_mixed_kernel.cu',
            'weight_handle.cu',
            'cublas.cu'
        ],
        include_dirs=['/disk/dual-fp-llm/cutlass/python/cutlass_library/../../include', '/disk/dual-fp-llm/cutlass/python/cutlass_library/../../tools/util/include'],
        extra_compile_args={
            'nvcc': [
                '-forward-unknown-to-host-compiler',
                '-DCUTLASS_VERSIONS_GENERATED',
                '-O3',
                '-DNDEBUG',
                '--generate-code=arch=compute_90a,code=[sm_90a]',
                '--generate-code=arch=compute_90a,code=[compute_90a]',
                #'-Xcompiler=-fPIE',
                '-DCUTLASS_ENABLE_TENSOR_CORE_MMA=1',
                '--expt-relaxed-constexpr',
                '-DCUTE_USE_PACKED_TUPLE=1',
                '-DCUTLASS_TEST_LEVEL=0',
                '-DCUTLASS_TEST_ENABLE_CACHED_RESULTS=1',
                '-DCUTLASS_DEBUG_TRACE_LEVEL=0',
                # '-Xcompiler=-Wconversion',
                '-Xcompiler=-fno-strict-aliasing',
                '-std=c++17',
                '-lineinfo'
                '-Xptxas',
                '-v',
                '-D__CUDA_ARCH_FEAT_SM90_ALL',
                '-DCUTE_SM90_EXTENDED_MMA_SHAPES_ENABLED'
            ],
        },
        libraries=['cuda']
        ),
    ],
    cmdclass={
        'build_ext': BuildExtension
    })
