

# Supplementary Material for ICLR22 submission: A Program to Build E(N)-Equivariant Steerable CNNs (https://openreview.net/forum?id=WE4qe9xlnQw)


To keep the submission anonymous, some parts of the code have been removed.
The code is not guaranteed to be entirely executable.

It contains four subpackages:

| Component                                                                | Description                                                      |
| -------------------------------------------------------------------------| ---------------------------------------------------------------- |
| `.group`                                                                 | implements basic concepts of *group* and *representation* theory, as well as different groups |
| `.kernels`                                                               | solves for spaces of equivariant convolution kernels             |
| `.gspaces`                                                               | defines spaces and the action of symmetry groups on them         |
| `.nn`                                                                    | contains equivariant modules to build deep neural networks       |
-------------------------------------------------------------------------------------------------------------------------------------------------


In particular, the kernel constraint is solved in the `.kernels` package.
`WignerEckartBasis` in `wignereckart_solver.py` solves the kernel constraint as described in (Lang & Weiler, 2020) on a homogeneous space `X` of `G`.
In the code, `X` is a `SpaceIsomorphism` which implements the embedding of a homogeneous space of `G` into `R^n`.
`RestrictedWignerEckartBasis` implements the special case of our Theorem we used in our experiments: it parameterizes `G`-equivariant kernels over an homogeneous space `X` of a larger group `G'`.
In our experiments we always use `G'=O(n)` and therefore `X` is always either a sphere (or circle if `n=2`) or a single point.
The full basis `B'` described in our paper is generated by taking the union of multiple spherical shells (and using a Gaussian radial profile).
This is done by `SphericalShellsBasis` in `polar_basis.py`.

Note that, in the paper we start from a steerable basis for the whole `L^2(R^n)` and then build a basis for steerable kernels.
Here, instead, we first build full kernel basis on each orbit and then merge these bases in `SphericalShellsBasis`; 
the final version of the code will be compatible with the version presented in the paper and will support more general initial steerable bases `B'`.

In `kernels/r3.py` we provide two methods `kernels_O3_subgroup_act_R3` and `kernels_SO3_subgroup_act_R3` which can be used to automatically build the kernel bases for any `G < O(3)` or `G < SO(3)` .
In the same file, these methods are used to instantiate all the kernel bases used in our paper.
`kernels_aliased_Ico_act_R3_*` are a special case: here, we build the basis using finite orbits of the Icosahedral group, which were evaluated in Sec. 5.2.





---

© 2021 Copyright claimant to remain anonymous during evaluation period. All rights reserved. May be used only pursuant to Software Evaluation Terms of Use.  CONFIDENTIAL – MAY CONTAIN TRADE SECRETS


