
clear all
data = 0.01:0.01:1;
[d,arms] = size(data);


kernel_index = 1;   % use 1 for SE kernel and 2 for Matern kernel
l = 0.2;
K = zeros(arms);
for i = 1 : arms
    for j = 1 : arms
        x = data(:,i);
        y = data(:,j);
        K(i,j) = kernel_function(x,y,l,kernel_index);
    end
end

rkhs_index = 1  % use 1 for RKHS functions with coefficients in [-1,1] and 2 for coefficients in [0,1]
p = 100;



R = 1;

T = 500
num_run = 1;
num_functions = 4;
tgp_regrets_total_stu = zeros(num_run,T);
tgp_regrets_avg_stu = zeros(num_run,T);

tgp_regrets_total_stu_restart = zeros(num_run,T);
tgp_regrets_avg_stu_restart = zeros(num_run,T);


[f, sample_points, weights] = gen_rkhs_function_new(data,l,p,rkhs_index,kernel_index,num_functions);
weight_1 = weights(1,:);
weight_2 = weights(2,:);
weight_3 = weights(3,:);
weight_4 = weights(4,:);
diff_1 = compute_diff_norm(weight_1, weight_2, sample_points,l,kernel_index);
diff_2 = compute_diff_norm(weight_2, weight_3, sample_points,l,kernel_index);
diff_3 = compute_diff_norm(weight_3, weight_4, sample_points,l,kernel_index);

P_T = diff_1 + diff_2 + diff_3;
H = round((T/P_T)^(2/3))*10;
% 
% f = gen_rkhs_function(data,l,p,rkhs_index,kernel_index);
% [f, sample_points, weights] = gen_rkhs_function_new(data,l,p,rkhs_index,kernel_index,2);
for run = 1:num_run
    run
    
    
    f_test = f;
    B = max(abs(f_test(1,:)));
    noise_index = 1; % use 1 for Gaussian and 2 for Pareto distribution
    if noise_index == 1
        
        alpha = 1;
        v = R^2;
        
    else
        noise_param = 2; % shape paremeter of Pareto distribution
        alpha = 0.9;
        v = (B^(1+alpha))/((2^alpha)*(1-alpha));
        c = v - B^(1+alpha);
    end

    lambda = 1;
    [~,tgp_regrets_total_stu(run,:),tgp_regrets_avg_stu(run,:)] = tgp_ucb(B,f_test,K,T,lambda,noise_index,alpha,v);
    
    lambda = 1;
    [~,tgp_regrets_total_stu_restart(run,:),tgp_regrets_avg_stu_restart(run,:)] = tgp_ucb_restart(B,f_test,K,T,lambda,noise_index,alpha,v,H);


end




