clear all;
tic


data = 0.01:0.01:1;
[d,arms] = size(data);

rng('default')
rng(6)

%generate kernel
kernel_index = 1;   % use 1 for SE kernel and 2 for Matern kernel
l = 0.2;
kernel = zeros(arms);
for i = 1 : arms
    for j = 1 : arms
        x = data(:,i);
        y = data(:,j);
        kernel(i,j) = kernel_function(x,y,l,kernel_index);
    end
end


%generate f_test
num_func = 3;

rkhs_index = 1;  % use 1 for RKHS functions with coefficients in [-1,1] and 2 for coefficients in [0,1]
p = 100;

[f_test, sample_points, weights] = gen_rkhs_function_new(data,l,p,rkhs_index,kernel_index,num_func);
weight_1 = weights(1,:);
weight_2 = weights(2,:);
weight_3 = weights(3,:);
%weight_4 = weights(4,:);
diff_1 = compute_diff_norm(weight_1, weight_2, sample_points,l,kernel_index);
diff_2 = compute_diff_norm(weight_2, weight_3, sample_points,l,kernel_index);
%diff_3 = compute_diff_norm(weight_3, weight_4, sample_points,l,kernel_index);
%diff_2=0;
diff_3=0;


%f_test = zeros(num_func, arms);
max_value = zeros(num_func, 1); max_arm = zeros(num_func, 1); B= zeros(num_func, 1);

for i = 1: num_func
    %f_test(i,:) = gen_rkhs_function(data,l,p,rkhs_index,kernel_index,x,a,i);
    [max_value(i),max_arm(i)] = max(f_test(i,:));
    B(i) = max(abs(f_test(i,:)));
end



save('function1.mat');