clear all;
tic

load('function1.mat');
rng('default')
rng(1)


T = 500;
num_run = 20;

%only 2 f_test
B_T = diff_1 + diff_2 + diff_3;
%H = round((T/P_T)^(2/3))*10;

H_pre = log(T)^(1/4) * T^(1/2) /B_T^(1/2);
H = 12*floor(H_pre)
SW = H;
gamma =  1- 1/(H_pre/5)


epsilon = 0.1;
R = 0.1;
lambda = 1;


et_gp_regrets_track = zeros(T,num_run);
et_gp_arm_track = zeros(T,num_run);
et_gp_triggers_track = zeros(T,num_run);
random_regrets_track = zeros(T,num_run);
gp_regrets_track = zeros(T,num_run);
gp_arm_track = zeros(T,num_run);
r_gp_regrets_track = zeros(T,num_run);
r_gp_arm_track = zeros(T,num_run);
sw_gp_regrets_track = zeros(T,num_run);
sw_gp_arm_track = zeros(T,num_run);
w_gp_regrets_track = zeros(T,num_run);
w_gp_arm_track = zeros(T,num_run);


for run = 1:num_run
    run

    B0 = max(abs(f_test(1,:)));
    noise_index = 1; % use 1 for Gaussian and 2 for Pareto distribution
    alpha = 1;
    v = R^2;

    [~,et_gp_regrets_track(:,run),~, et_gp_triggers_track(:,run)] = b_et_gp_ucb(B0,f_test,kernel,T,lambda,noise_index,alpha,v,H);

    [~,gp_regrets_track(:,run),~] = tgp_ucb(B0,f_test,kernel,T,lambda,noise_index,alpha,v);

    [~,random_regrets_track(:,run),~] = random_search(B0,f_test,kernel,T,lambda,noise_index,alpha,v);
    

    [~,r_gp_regrets_track(:,run),~] = tgp_ucb_restart(B0,f_test,kernel,T,lambda,noise_index,alpha,v,H);
    
    
    %SW = T;
     [sw_gp_regrets_track(:,run), sw_gp_arm_track(:,run)] = sw_gp_ucb(SW ,B ,f_test,kernel,T,lambda,v,R);

    
    %gamma = 1;
     [w_gp_regrets_track(:,run), w_gp_arm_track(:,run)] = w_gp_ucb(gamma ,B, f_test,kernel,T,lambda,v,R);
end


toc

save('regret_slowly_changing_reasonable_noise_2.mat');


beep on
beep