clear all;
%load('regret_final.mat');
load('regret_slowly_changing_reasonable_noise_2.mat');

random_total = mean(random_regrets_track,2);
et_gp_total = mean(et_gp_regrets_track,2);
gp_total = mean(gp_regrets_track,2);
rgp_total = mean(r_gp_regrets_track,2);
swgp_total = mean(sw_gp_regrets_track,2);
wgp_total = mean(w_gp_regrets_track,2);

err_random_total = std(random_regrets_track,0,2);
err_et_gp_total = std(et_gp_regrets_track,0,2);
err_gp_total = std(gp_regrets_track,0,2);%S = std(A,w,dim)
err_rgp_total = std(r_gp_regrets_track,0,2); 
err_swgp_total = std(sw_gp_regrets_track,0,2);
err_wgp_total = std(w_gp_regrets_track,0,2);

text = ['GP-UCB: Mean_regret is ', num2str(gp_total(end)), ', Stdv is ', num2str(err_gp_total(end))];
disp(text)
text = ['R-GP-UCB: Mean_regret is ', num2str(rgp_total(end)), ', Stdv is ', num2str(err_rgp_total(end))];
disp(text)
text = ['SW-GP-UCB: Mean_regret is ', num2str(swgp_total(end)), ', Stdv is ', num2str(err_swgp_total(end))];
disp(text)
text = ['W-GP-UCB: Mean_regret is ', num2str(wgp_total(end)), ', Stdv is ', num2str(err_wgp_total(end))];
disp(text)
text = ['ET-GP-UCB: Mean_regret is ', num2str(et_gp_total(end)), ', Stdv is ', num2str(err_et_gp_total(end))];
disp(text)

%X_2 = [2:2:20]*1000;
%X = [1,X_2];
X_2 = [1:1:T/50]*50;
X = [1, X_2];
%X = 1:40:T;
errorbar(X,random_total(X),err_random_total(X),'g','linewidth',4,'Marker','+','MarkerSize',20,'linestyle',':')
hold on
errorbar(X,et_gp_total(X),err_et_gp_total(X),'k','linewidth',4,'Marker','+','MarkerSize',20,'linestyle',':')
hold on
%X = 1:40:T;
errorbar(X,gp_total(X),err_gp_total(X),'yellow','linewidth',4,'Marker','+','MarkerSize',20,'linestyle',':')
hold on
errorbar(X,rgp_total(X),err_rgp_total(X),'r','linewidth',4,'Marker','x','MarkerSize',20,'linestyle','-.')
hold on
errorbar(X,swgp_total(X),err_swgp_total(X),'b', 'linewidth',4,'Marker','o','MarkerSize',20,'linestyle','--')
hold on
errorbar(X,wgp_total(X),err_wgp_total(X),'color',[0.13,0.54,0.13],'linewidth',4,'Marker','v','MarkerSize',20,'linestyle','-')
%axis([0,20000,0,4e4])
axis([-10,T*1.1,0,max(gp_total)*1.5]) 
set(gcf,'unit','normalized','position',[0.05,0.05,0.85,0.85]);  %position within the whole screen 
set(gca,'fontweight','bold','FontSize',28)
xlabel('Iteration','FontSize',40)
ylabel('Cumulative Regret','FontSize',40)
legend({'Random','ET-GP-UCB','IGP-UCB','R-GP-UCB','SW-GP-UCB','W-GP-UCB'},'FontSize',46, 'Location','northwest','FontWeight','Normal')






 