
function [regrets_track, arm_track, trigger_track] = et_gp_ucb(B,f_test,kernel,T,lambda,epsilon,R,max_value, options)
   
        data_mean = options(1);
        data_stdv = options(2);
        
        [~, arms] = size(f_test(1,:));
        %[max_value,max_arm] = max(f_test);
        %kernel_t = kernel;
        mu_t = zeros(arms,1); sigma2_t = zeros(arms,1);
        
        regrets_cumula = 0;
        regrets_track = zeros(T,1);

        rewards_cumula = 0;
        rewards_track = zeros(T,1);
        
        arm_track = zeros(T,1);
        trigger_track = zeros(T,1);
        y_track = zeros(T,1);
        
        num_func = size(B,1);
        iter_func = 0;
        
        c1 = 0.8;
        c2 = 0.4;
        delta_T = 0.1;

        reset = false;
        t1 = 1;
        
        for t = 1 : T   
                iter_func = iter_func+1;
                   
%                 if reset
%                     t1 = H;
%                 else
%                     t1 = mod(t,H);
%                 end

                pi_t = pi^2 * t^2 / 6;
                beta_t = sqrt(2 * log(2 * pi_t / 0.1));
                if t == 1
                    arm_t = randi(arms);
%                     mu_t = zeros(arms,1); sigma2_t = zeros(arms,1);
                else
                    [~,arm_t] = max( mu_t +  beta_t*sqrt(sigma2_t) );
                end
                arm_track(t) = arm_t;
                
                rewards_cumula = rewards_cumula + f_test(iter_func,arm_t);
                rewards_track(t) = rewards_cumula;
                               
                
                regrets_cumula = regrets_cumula + (max_value(iter_func) - f_test(iter_func,arm_t))*data_stdv;
                regrets_track(t) = regrets_cumula;

                noise = randn;  %sub-gaussian  normal 
                y_t = f_test(iter_func,arm_t);
                y_track(t) = y_t;
            
                % get prediction at query point
                if t > 1
                    mean_pred = transpose( ktx(:, arm_t) ) * inverse_k * y1t;
                    stdv_pred = sqrt(kernel(arm_t,arm_t) - transpose( ktx(:, arm_t) )* inverse_k * ktx(:, arm_t));
                    reset = et_gp_ucb_trigger(mean_pred, stdv_pred, y_t, length(y1t), epsilon, delta_T);
                    
                    if reset
                        t1 = 1;
                        X = ['RESET AT t=', num2str(t)];
                        disp(X)
                        trigger_track(t) = 1;
                    else
                        t1 = t1 + 1;
                    end
                end
                   
%                 y1t = y_track(t1 : t);
                y1t = y_track(t- t1 + 1 : t);
                
                ktx = zeros(t1, arms);
                Kt = zeros(t1, t1);
                for i = 1 : t1
                    ktx(i, :) = kernel(arm_track(t-t1+i),:);
                    for j = 1 : t1
                        Kt(i,j) = kernel(arm_track(t-t1+i), arm_track(t-t1+j));
                    end
                end

                % check trigger

                inverse_k = inv(Kt + lambda*eye(t1));
                for k = 1 : arms
                    mu_t (k) = transpose( ktx(:, k) ) * inverse_k * y1t;
                    sigma2_t(k) = kernel(k,k) - transpose( ktx(:, k) )* inverse_k * ktx(:, k);
                end
                

                
            
        end
        
end

    

