clear all;
tic

load('function1_test.mat');
rng('default')
rng(2)

T = 500;
num_run = 20;

time_change = zeros(num_func, 1);
time_change(1) = 0;
time_change(2) = T/5;
time_change(3) = T/2.5;
%time_change(4) = 500;
%time_change(4) = 50;
%time_change(5) = 50;

B_T = diff_1 + diff_2 + diff_3;
%H = round((T/P_T)^(2/3))*10;

H_pre = log(T)^(1/4) * T^(1/2) /B_T^(1/2);
H = 2*floor(H_pre)
SW = H;
gamma =  1- 1/(2*H_pre)


epsilon = 0.1;
R = 0.1
lambda = 1;


et_gp_regrets_track = zeros(T,num_run);
et_gp_arm_track = zeros(T,num_run);
et_gp_triggers_track = zeros(T,num_run);
random_regrets_track = zeros(T,num_run);
gp_regrets_track = zeros(T,num_run);
gp_arm_track = zeros(T,num_run);
r_gp_regrets_track = zeros(T,num_run);
r_gp_arm_track = zeros(T,num_run);
sw_gp_regrets_track = zeros(T,num_run);
sw_gp_arm_track = zeros(T,num_run);
w_gp_regrets_track = zeros(T,num_run);
w_gp_arm_track = zeros(T,num_run);


for run = 1:num_run
    run
    
    B0 = max(abs(f_test(1,:)));
    noise_index = 1; % use 1 for Gaussian and 2 for Pareto distribution
    alpha = 1;
    v = R^2;
    
    [~,et_gp_regrets_track(:,run),~,et_gp_triggers_track(:,run)] = a_et_gp_ucb(B0,f_test,kernel,T,lambda,noise_index,alpha,epsilon,H);

    [~,gp_regrets_track(:,run),~] = tgp_ucb(B0,f_test,kernel,T,lambda,noise_index,alpha,epsilon);
    
    [~,random_regrets_track(:,run),~] = random_search(B0,f_test,kernel,T,lambda,noise_index,alpha,epsilon);

    [~,r_gp_regrets_track(:,run),~] = tgp_ucb_restart(B0,f_test,kernel,T,lambda,noise_index,alpha,epsilon,H);
    
    
    %[gp_regrets_track(:,run), gp_arm_track(:,run) ] = gp_ucb(B0,f_test,kernel,T,lambda,epsilon,R,time_change,max_value,max_arm);
    
    %H = T;
    %[r_gp_regrets_track(:,run), r_gp_arm_track(:,run)]= r_gp_ucb(H, B,f_test,kernel,T,lambda,epsilon,R,time_change,max_value,max_arm);
    
    %SW = T;
    [sw_gp_regrets_track(:,run), sw_gp_arm_track(:,run)] = sw_gp_ucb(SW ,B ,f_test,kernel,T,lambda,epsilon,R,time_change,max_value,max_arm);

    %gamma = 1;
    [w_gp_regrets_track(:,run), w_gp_arm_track(:,run)] = w_gp_ucb(gamma ,B, f_test,kernel,T,lambda,epsilon,R,time_change,max_value,max_arm);
end


toc

save('regret_abruptly_changing_reasonable_noise_2.mat'); % _reasonable_noise


beep on
beep

