function [cumulative_regret,regrets_total, regrets_avg, triggers]= a_et_gp_ucb(B,f_star,K,T,lambda,n_ind,alpha,noise,H)
 
    [~, arms] = size(f_star(1,:));
    
    kernel = K;
    cov_mat = K;
    mean_vec = zeros(arms,1);
    mu_t = zeros(arms,1);
    sigma_t = zeros(arms,1);

    cumulative_regret = 0;
    regrets_total = zeros(T,1);
    regrets_avg = zeros(1,T);
    triggers = zeros(1,T);

    arm_track = zeros(T,1);
    y_track = zeros(T,1);
    
    c1 = 0.4;
    c2 = 0.8;
    delta_T = 0.1;
    t1 = 1;
        
    for round = 1 : T
        if round <= T/2
                f = f_star(1,:) + (f_star(2,:) - f_star(1,:))* (2* round/T);
        else
            f = f_star(2,:) + (f_star(3,:) - f_star(2,:))* (  (2* round - T)/T);
        end
    
        
    %             if round <= 2000
    %                 f = f_star(1,:);
    %             elseif round > 2000 && round <= 6000
    %                 f = f_star(2,:);
    %             elseif round > 6000 && round < 10000
    %                 f = f_star(3,:);
    %             else
    %                 f = f_star(4,:);
    %             end
        
        % optimize acquisition function
        pi_t = pi^2 * round^2 / 6;
        beta_t = sqrt(2 * log(2 * pi_t / 0.1));
%         beta_t = sqrt(c1 * log(c2 * round));
        if round == 1
            arm_pld = randi(arms);
        else
            [~,arm_pld] = max(mu_t + beta_t*sqrt(sigma_t));
        end
        arm_track(round) = arm_pld;
        [opt_value,~] = max(f);
        cumulative_regret = cumulative_regret + opt_value - f(arm_pld);
        regrets_total(round) = cumulative_regret;
        regrets_avg(round) = cumulative_regret/round;
        
        if n_ind == 1
            sigma = sqrt(noise);
            obs = f(arm_pld);
            added_noise = normrnd(0,sigma);
            reward_obt =  obs + added_noise;
        elseif n_ind == 2
            kval = 1/n_param;
            thta = (n_param-1)*f(arm_pld)/n_param;
            sgma = thta/n_param;
            reward_obt = gprnd(kval,sgma,thta);
        else
            reward_obt = n_param(randi(size(n_param,1)),arm_pld);
        end
        
        y_track(round) = reward_obt;


        if round > 1
            mean_pred = ktx(:, arm_pld)' * inverse_k * y1t;
            var_pred = kernel(arm_pld, arm_pld) - ktx(:, arm_pld)' * inverse_k * ktx(:, arm_pld);
            stdv_pred = sqrt(var_pred);
            reset = et_gp_ucb_trigger(mean_pred, stdv_pred, reward_obt, length(y1t), sigma, delta_T);
            
            if reset
                t1 = 1;
                X = ['RESET AT t=', num2str(round)];
                disp(X)
                triggers(round) = 1;
            else
                t1 = t1 + 1;
            end
        end

        y1t = y_track(round- t1 + 1 : round);

        ktx = zeros(t1, arms);
        Kt = zeros(t1, t1);
        for i = 1 : t1
            ktx(i, :) = kernel(arm_track(round-t1+i),:);
            for j = 1 : t1
                Kt(i,j) = kernel(arm_track(round-t1+i), arm_track(round-t1+j));
            end
        end
        
        % mean    
        inverse_k = inv(Kt + sigma^2 * eye(t1));
        mu_t = ktx' * inverse_k * y1t;
        
        % variance
        sigma_t = diag(kernel - ktx' * inverse_k * ktx);

%         [mean_vec,cov_mat] = posterior_update(mean_vec,cov_mat,reward_obt,arm_pld,sigma);
%         
% %         plot(mean_vec)
% %         hold on
% %         plot(mu_t)
% %         hold off
% 
%         var_vec = (1/lambda)*diag(cov_mat);
%         
%         if mod(round,H) == 0
%             cov_mat = K;
%             mean_vec = zeros(arms,1);
%             var_vec = (1/lambda)*diag(cov_mat);
%         end

        
    end

end
