function [cumulative_regret,regrets_total, regrets_avg]= tgp_ucb_restart(B,f_star,K,T,lambda,n_ind,alpha,v,H)
 
        [~, arms] = size(f_star(1,:));
        
        cov_mat = K;
        mean_vec = zeros(arms,1);
        
        cumulative_regret = 0;
        regrets_total = zeros(T,1);
        regrets_avg = zeros(1,T);
            
            
        for round = 1 : T
            if round <= T/2
                f = f_star(1,:) + (f_star(2,:) - f_star(1,:))* (2* round/T);
            else
                f = f_star(2,:) + (f_star(3,:) - f_star(2,:))* (  (2* round - T)/T);
            end
            
%             if round <= T/5
%                 f = f_star(1,:);
%             elseif round > T/5 && round <= T/2.5
%                 f = f_star(2,:);
% %             elseif round > 6000 && round < 10000
% %                 f = f_star(3,:);
%             else
%                 f = f_star(3,:);
%             end
            
            
            
%             if round <= 2000
%                 f = f_star(1,:);
%             elseif round > 2000 && round <= 6000
%                 f = f_star(2,:);
%             elseif round > 6000 && round < 10000
%                 f = f_star(3,:);
%             else
%                 f = f_star(4,:);
%             end
            
            beta_t = B*sqrt(lambda) + v^(1/(1+alpha))*sqrt(log(round)); 
            if round == 1
                arm_pld = randi(arms);
            else
                [~,arm_pld] = max(mean_vec + beta_t*sqrt(var_vec));
            end
            [opt_value,~] = max(f);
            cumulative_regret = cumulative_regret + opt_value - f(arm_pld);
            regrets_total(round) = cumulative_regret;
            regrets_avg(round) = cumulative_regret/round;
            
            if n_ind == 1
                sigma = sqrt(v);
                reward_obt =  f(arm_pld) + normrnd(0,sigma);
            elseif n_ind == 2
                kval = 1/n_param;
                thta = (n_param-1)*f(arm_pld)/n_param;
                sgma = thta/n_param;
                reward_obt = gprnd(kval,sgma,thta);
            else
                reward_obt = n_param(randi(size(n_param,1)),arm_pld);
            end
            
           
            [mean_vec,cov_mat] = posterior_update(mean_vec,cov_mat,reward_obt,arm_pld,lambda);
            var_vec = (1/lambda)*diag(cov_mat);
            
            if mod(round,H) == 0
                cov_mat = K;
                mean_vec = zeros(arms,1);
                var_vec = (1/lambda)*diag(cov_mat);
            end
            
            
        end
    
end
