clear all;
tic

fin = importfile('fin.csv', 2, 824);
data = fin(:,all(~isnan(fin)));
[num_func, arms] = size(data);
mean_stocks = mean(data);
sigma_stocks = std(data);
noise = (data - repmat(mean_stocks,num_func,1))./repmat(sigma_stocks,num_func,1);

%f_test = repmat(mean_stocks,num_func,1);
%K = cov(noise);
f_test = repmat(mean_stocks,num_func,1) + (data - repmat(mean_stocks,num_func,1))/15;
K = cov(f_test./repmat(sigma_stocks,num_func,1))*225;
%K = cov(f_test);
%maxK = max(max(K));
kernel = K;
B=zeros(num_func,1);
for i=1:num_func
    B(i) = max(f_test(i,:));
end

max_value=B;

T = 823;

%only 823 f_test
B_T = 0;
for i = 2:5
    B_T = B_T + norm(f_test(i,:)-f_test(i-1,:) ,2);
end

B_T= 0.006;
H_pre = log(T)^(1/4) * T^(1/2) /B_T^(1/2)
%H_pre = 600
H = floor(H_pre);
SW = H;
gamma = ( 1- 1/H_pre)


epsilon = 300;
R = 1;
lambda = 1;

num_run=5;

random_regret_track = zeros(T,num_run);
random_arm_track = zeros(T,num_run);
et_gp_regrets_track = zeros(T,num_run);
et_gp_arm_track = zeros(T,num_run);
et_gp_triggers_track = zeros(T,num_run);
gp_regrets_track = zeros(T,num_run);
gp_arm_track = zeros(T,num_run);
r_gp_regrets_track = zeros(T,num_run);
r_gp_arm_track = zeros(T,num_run);
sw_gp_regrets_track = zeros(T,num_run);
sw_gp_arm_track = zeros(T,num_run);
w_gp_regrets_track = zeros(T,num_run);
w_gp_arm_track = zeros(T,num_run);

rng('default');
rng(2);

for run = 1:num_run
    run
    disp('Start RANDOM')
    [random_regret_track(:,run), random_arm_track(:,run)] = random_search(B,f_test,kernel,T,lambda,epsilon,R,max_value);

    disp('Start ET-GP-UCB')
    [et_gp_regrets_track(:,run), et_gp_arm_track(:,run), et_gp_triggers_track] = et_gp_ucb(B,f_test,kernel,T,lambda,epsilon,R,max_value);

    lambda = 1;   
    [gp_regrets_track(:,run), gp_arm_track(:,run)] = gp_ucb(B,f_test,kernel,T,lambda,epsilon,R,max_value);
    
    [r_gp_regrets_track(:,run), r_gp_arm_track(:,run)] = r_gp_ucb(H, B,f_test,kernel,T,lambda,epsilon,R,max_value);
    
    [sw_gp_regrets_track(:,run), sw_gp_arm_track(:,run)] = sw_gp_ucb(SW, B,f_test,kernel,T,lambda,epsilon,R,max_value);
    
    [w_gp_regrets_track(:,run), w_gp_arm_track(:,run)] = w_gp_ucb(gamma, B,f_test,kernel,T,lambda,epsilon,R,max_value);

end

toc

save('regret_original.mat');


beep on
beep