function [reset] = et_gp_ucb_trigger(mean_pred,stdv_pred, y_mes, n_training_points, noise, delta_T)
%ET_GP_UCB_TRIGGER Summary of this function goes here
%   Detailed explanation goes here

diff = abs(mean_pred - y_mes);

% get rho_t
pi_t = (pi^2 * n_training_points^2) / 6;
sqr_rho_t = sqrt(2 * log(2*pi_t / (1 * delta_T)));

% create bound
bound = sqr_rho_t * stdv_pred;
noise_bound = sqrt(2 * noise^2 * log(2*pi_t / delta_T));
total_bound = bound + noise_bound;

% evaluate trigger
reset = diff > total_bound;
if reset
    disp(['Diff was ', num2str(diff),'. Bound was ', num2str(total_bound)])
end
