# Policy Gradient with Kernel Quadrature

This repository includes two independent repositories used for the experiments in the paper "Policy Gradient with Kernel Quadrature".

## Experiments

Running `bash ppo_compare.sh`
with appropriate modifications of `args.env_name` and `method_names` in `ppo_compare.py` (L331 and L338, respectively) will reproduce the experiments.
However, you may need to modify the paths tailored to your computing environments.
The experiments took a month in total with a Google Cloud Vertex AI notebook
with an NVIDIA T4 (16-core vCPU, 60 GB RAM).

## Dependencies

The experiment here is mainly based on `machina` (https://github.com/DeepX-inc/machina/tree/master). The repository is partially forked and modified, but you still require the dependencies of the original asset.

You need to install `mujoco(>=2.1.0)` (https://github.com/google-deepmind/mujoco/releases/tag/2.1.0) and execute `pip install gymnasium[mujoco]`.

You also need to do `pip install goodpoints` for running thinning-based PGKQ algorithms given in Appendix C.

## License dependencies

This asset depends on the MIT License of
- `machina` (https://github.com/DeepX-inc/machina/blob/master/LICENSE),
- `kernel-quadrature`
(https://github.com/satoshi-hayakawa/kernel-quadrature/blob/main/LICENSE),
- `Recombination_Random_Algos` (https://github.com/FraCose/Recombination_Random_Algos/blob/master/LICENSE), and
- `goodpoints` (https://github.com/microsoft/goodpoints/blob/main/LICENSE).

