import torch
import numpy as np
import matplotlib.pyplot as pl
import pandas as pd
from sklearn.model_selection import train_test_split
import torch.nn as nn

from sklearn.metrics import roc_auc_score,accuracy_score,precision_score
torch.set_default_dtype(torch.float64)

df=pd.read_csv('out_n.csv').to_numpy()
X=df[:,:3]
y=df[:,3:]
X_tr,X_t,y_tr,y_t=train_test_split(X,y,test_size=0.5)
tor_X_tr=torch.tensor(X_tr)
tor_y_tr=torch.tensor(y_tr)
tor_X_t=torch.tensor(X_t)
tor_y_t=torch.tensor(y_t)

n_seq=nn.Sequential(
    nn.Linear(3,150),
    nn.Tanh(),
    nn.Linear(150,150),
    nn.Tanh(),
    nn.Linear(150,150),
    nn.Tanh(),
    nn.Linear(150,1),
    nn.Sigmoid()
)

optimiser=torch.optim.Adam(n_seq.parameters(),lr=0.001)

for i in range(5000):      
    optimiser.zero_grad()
    idx = torch.randperm(len(tor_X_tr))[:1000]
    batch_x=tor_X_tr[idx]
    batch_y=1-tor_y_tr[idx]
    y_pred=n_seq(batch_x)
    BSE=nn.BCELoss()
    loss=BSE(y_pred,batch_y)
    if(i%100==0):
        print(str(i)+': '+str(loss))
    loss.backward()
    optimiser.step()
    
y_pred=n_seq(tor_X_t)
y_pred_v=torch.zeros(y_pred.shape)
y_pred_v[y_pred[:,0]>0.5]=1
print(roc_auc_score(y_pred_v.detach(),1-tor_y_t))
print(accuracy_score(y_pred_v.detach(),1-tor_y_t))
print(precision_score(y_pred_v.detach(),1-tor_y_t))
