clear; close all; clc;

%% Extract PRD Only

%     tailored_prd1(i,:) = [results(i).tailored.eval_stats.prd];
%     ddbd_dict_prd1(i,:) = [results(i).ddbd_dict.eval_stats.prd];
%     ddbd_wave_prd1(i,:) = [results(i).ddbd_wave.eval_stats.prd];
%     bern_dct_prd1(i,:) = [results(i).bern_dct.eval_stats.prd];
%     gauss_dct(i,:) = [results(i).gauss_dct.eval_stats.prd];

cr_vals = [2, 3, 4, 5, 7, 10, 15, 20, 25, 50, 60, 100];

do_eval = false;
do_idx = false;
do_pwr = true;
do_c_psi = false;
do_time = false;


for i=1:length(cr_vals)

    mat_file = strcat(num2str(cr_vals(i)), '.mat');
    mat_file_idx = strcat(num2str(cr_vals(i)), '_idx.mat');
    mat_file_pwr = strcat(num2str(cr_vals(i)), '_pwr.mat');
    mat_file_time = strcat(num2str(cr_vals(i)), '_time.mat');

    load(strcat("data\results\", mat_file));
    
    if do_eval
        tailored = results.tailored.eval_stats;
        ddbd_dict = results.ddbd_dict.eval_stats;
        ddbd_wave = results.ddbd_wave.eval_stats;
        bern_dct = results.bern_dct.eval_stats;
        gauss_dct = results.gauss_dct.eval_stats;
        save(strcat('data\results_trimmed\', mat_file), 'tailored', 'ddbd_dict', 'ddbd_wave', 'bern_dct', 'gauss_dct');
        clear tailored;
        clear ddbd_dict;
        clear ddbd_wave;
        clear bern_dct;
        clear gauss_dct;
    end

    if do_idx
        test_idx.tailored.test = results.tailored.test_idx;
        test_idx.tailored.train = results.tailored.train_idx;
        test_idx.subset = results.subset;
        save(strcat('results_trimmed\', mat_file_idx), 'test_idx');
        clear test_idx;
    end

    if do_pwr
        tailored = results.tailored.pwr_dat;
        ddbd_dict = results.ddbd_dict.pwr_dat;
        ddbd_wave = results.ddbd_wave.pwr_dat;
        bern_dct = results.bern_dct.pwr_dat;
        gauss_dct = results.gauss_dct.pwr_dat;

        save(strcat('results_trimmed\', mat_file_pwr), 'tailored', 'ddbd_dict', 'ddbd_wave', 'bern_dct', 'gauss_dct');
        clear test_idx;
    end

    if do_time
        solve_time = zeros(4,10000);
        solve_time(1,:) = results.ddbd_dict.solve_time';
        solve_time(2,:) = results.ddbd_wave.solve_time';
        solve_time(3,:) = results.bern_dct.solve_time';
        solve_time(4,:) = results.gauss_dct.solve_time';

        save(strcat('results_trimmed\', mat_file_time), 'solve_time');
        clear test_idx;
    end
    

    clear results;

end



