#!/bin/bash

export PYTHONPATH="/path/to/reservoir-conformal-prediction-dev-main/:$PYTHONPATH"

# Solar
python run_RExCP_sampling.py src_dir="/path/to/logs/base/solar/rnn/2025-07-16/17-55-58/" dataset=solar add_exogenous=False conformal_predictor=rexcp_sampling_solar_rnn sampler=solar_rnn
python run_RExCP_sampling.py src_dir="/path/to/logs/base/solar/arima/2025-07-27/14-47-17/" dataset=solar add_exogenous=False conformal_predictor=rexcp_sampling_solar_arima sampler=solar_arima
python run_RExCP_sampling.py src_dir="/path/to/logs/base/solar/transformer/2025-07-22/16-22-57/" dataset=solar add_exogenous=False conformal_predictor=rexcp_sampling_solar_transformer sampler=solar_transformer

# Beijing
python run_RExCP_sampling.py src_dir="/path/to/logs/base/beijing/rnn/2025-07-16/17-50-09/" dataset=beijing add_exogenous=False conformal_predictor=rexcp_sampling_beijing_rnn sampler=beijing_rnn +clip_residuals=True
python run_RExCP_sampling.py src_dir="/path/to/logs/base/beijing/arima/2025-07-24/04-12-06/" dataset=beijing add_exogenous=False conformal_predictor=rexcp_sampling_beijing_arima sampler=beijing_arima +clip_residuals=True
python run_RExCP_sampling.py src_dir="/path/to/logs/base/beijing/transformer/2025-07-22/16-19-56/" dataset=beijing add_exogenous=False conformal_predictor=rexcp_sampling_beijing_transformer sampler=beijing_transformer +clip_residuals=True

# Exchange
python run_RExCP_sampling.py src_dir="/path/to/logs/base/exchange/rnn/2025-08-25/14-38-06" dataset=exchange add_exogenous=False conformal_predictor=rexcp_sampling_exchange_rnn sampler=exchange_rnn
python run_RExCP_sampling.py src_dir="/path/to/logs/base/exchange/arima/2025-08-25/14-42-35" dataset=exchange add_exogenous=False conformal_predictor=rexcp_sampling_exchange_arima sampler=exchange_arima
python run_RExCP_sampling.py src_dir="/path/to/logs/base/exchange/transformer/2025-08-25/14-40-48" dataset=exchange add_exogenous=False conformal_predictor=rexcp_sampling_exchange_transformer sampler=exchange_transformer

# ACEA
python run_RExCP_sampling.py src_dir="/path/to/logs/base/elec/rnn/2025-09-01/11-44-56" dataset=elec add_exogenous=False conformal_predictor=rexcp_sampling_elec_rnn sampler=elec_rnn
python run_RExCP_sampling.py src_dir="/path/to/logs/base/elec/arima/2025-09-01/11-57-39" dataset=elec add_exogenous=False conformal_predictor=rexcp_sampling_elec_arima sampler=elec_arima
python run_RExCP_sampling.py src_dir="/path/to/logs/base/elec/transformer/2025-09-01/11-54-31" dataset=elec add_exogenous=False conformal_predictor=rexcp_sampling_elec_transformer sampler=elec_transformer