/*
 * proto-suff
 * Copyright (C) 2020  Univ. Artois & CNRS
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#pragma once

#include <boost/python.hpp>
#include <vector>

#include "Tree.hpp"

namespace protoss {
class MinimumMajoritaryExplainer {
private:
  unsigned m_maxFeatureIndex = 0;
  unsigned m_minFeatureIndex = 0;

  std::vector<Tree *> forest;

public:
  MinimumMajoritaryExplainer();
  ~MinimumMajoritaryExplainer();
  void addTree(const boost::python::list &);
  boost::python::list explain(const boost::python::list &);
  int getScore(int feature);
};
} // namespace protoss