/*
 * proto-suff
 * Copyright (C) 2020  Univ. Artois & CNRS
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
#pragma once
#include "Node.hpp"
#include <sys/types.h>
#include <vector>

namespace protoss {
const static u_char LIT_UNDEF = 0;
const static u_char LIT_TRUE = 1;
const static u_char LIT_FALSE = 2;
const static int BOTTOM = -2;
const static int TOP = -1;

class Tree {
private:
  u_char *m_memory = nullptr;
  Node *m_root = nullptr;
  std::vector<bool> m_usedToExplain;
  std::vector<int> m_usedList;
  std::vector<int> m_nbCritical;
  int m_savedClass;
  int m_maxIdentifier;
  bool m_hasBeenCorrectlyClassified;

public:
  ~Tree();
  void parse(std::vector<int> &rawTree);
  void display();
  int initExample(std::vector<u_char> &storedExample);
  bool canRemoveFeature(std::vector<u_char> &storedExample, int feature);
  void undoLastModification();

  inline int getSavedClass() { return m_savedClass; }
  inline int getMaxIdentifier() { return m_maxIdentifier; }
  inline Node *getRoot() { return m_root; }
  inline bool hasBeenCorrectlyClassified() {
    return m_hasBeenCorrectlyClassified;
  }
};
} // namespace protoss