/*
 * proto-suff
 * Copyright (C) 2020  Univ. Artois & CNRS
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
#pragma once

#include <iostream>
#include <sys/types.h>
#include <vector>

namespace protoss {
class Node {
private:
  int m_identifier;
  Node *m_falseBranch;
  Node *m_trueBranch;

public:
  Node(int identifier);
  Node(int identifier, Node *falseBranch, Node *trueBranch);
  void display();

  // accessors.
  inline void setIdentifier(int identifier) { m_identifier = identifier; }
  inline void setFalseBranch(Node *n) { m_falseBranch = n; }
  inline void setTrueBranch(Node *n) { m_trueBranch = n; }
  inline Node *getFalseBranch() { return m_falseBranch; }
  inline Node *getTrueBranch() { return m_trueBranch; }
  inline int getIdentifier() { return m_identifier; }

  int getClass(std::vector<u_char> &storedExample, std::vector<int> &usedList,
               std::vector<bool> &usedToExplain);
};
} // namespace protoss