import copy

from tableshift.core.features import FeatureList, Feature, cat_dtype
from tableshift.datasets.grinsztajn import (
    DEFAULT_OF_CREDIT_CLIENTS_FEATURES,
    ROAD_SAFETY_FEATURES,
    BANK_MARKETING_FEATURES,
    CREDIT_FEATURES,
    HIGGS_FEATURES,
)

BANK_FULL_FEATURES = FeatureList(
    features=[
        Feature("age", int, name_extended="age in years"),
        Feature("job", cat_dtype, name_extended="type of job held by client"),
        Feature("marital", cat_dtype, name_extended="marital status"),
        Feature("education", cat_dtype, name_extended="education level"),
        Feature(
            "default",
            cat_dtype,
            name_extended="indicator for whether client currently has credit in default",
        ),
        Feature("balance", int, name_extended="average yearly balance (in USD)"),
        Feature(
            "housing",
            cat_dtype,
            name_extended="indicator for whether client currently has housing loan",
        ),
        Feature(
            "loan",
            cat_dtype,
            name_extended="indicator for whether client currently has a personal loan",
        ),
        Feature("contact", cat_dtype, name_extended="contact communication type"),
        Feature("day_of_week", int, name_extended="last contact day of the month"),
        Feature("month", cat_dtype, name_extended="last contact month of the year"),
        Feature(
            "campaign",
            int,
            name_extended="number of contacts performed during this campaign and for this client",
        ),
        Feature(
            "pdays",
            int,
            name_extended="number of days that passed by after the client was last contacted from a previous campaign (-1 means client was not previously contacted)",
        ),
        Feature(
            "previous",
            int,
            name_extended="number of contacts performed before this campaign and for this client",
        ),
        Feature(
            "poutcome",
            cat_dtype,
            name_extended="outcome of the previous marketing campaign",
        ),
        Feature(
            "y",
            int,
            is_target=True,
            name_extended="Client will subscribe to a term deposit",
        ),
    ],
    documentation=BANK_MARKETING_FEATURES.documentation,
)
COVERTYPE_FULL_FEATURES = FeatureList(
    features=[
        Feature(
            "Cover_Type",
            int,
            name_extended="forest cover type designation is Lodgepole Pine",
            is_target=True,
        ),
        # Feature(
        #     "class",
        #     int,
        #     is_target=True,
        #     name_extended="forest cover type designation is Lodgepole Pine",
        # ),
        Feature("Elevation", int, name_extended="elevation in meters"),
        Feature("Aspect", int, name_extended="aspect in degrees azimuth"),
        Feature("Slope", int, name_extended="slope in degrees"),
        Feature(
            "Horizontal_Distance_To_Hydrology",
            int,
            name_extended="horizontal distance to nearest surface water features in meters",
        ),
        Feature(
            "Vertical_Distance_To_Hydrology",
            int,
            name_extended="vertical distance to nearest surface water features in meters",
        ),
        Feature(
            "Horizontal_Distance_To_Roadways",
            int,
            name_extended="horizontal distance to nearest roadway in meters",
        ),
        Feature(
            "Hillshade_9am",
            int,
            name_extended="Hillshade index at 9am on summer solstice",
        ),
        Feature(
            "Hillshade_Noon",
            int,
            name_extended="Hillshade index at noon on summer solstice",
        ),
        Feature(
            "Hillshade_3pm",
            int,
            name_extended="Hillshade index at 3pm on summer solstice",
        ),
        Feature(
            "Horizontal_Distance_To_Fire_Points",
            int,
            name_extended="horizontal distance to nearest wildfire ignition points in meters",
        ),
        Feature(
            "Wilderness_Area",
            cat_dtype,
            name_extended="code for wilderness area designation.",
        ),
        Feature(
            "Soil_Type1", int, name_extended="indicator for soil type 1 designation"
        ),
        Feature(
            "Soil_Type2", int, name_extended="indicator for soil type 2 designation"
        ),
        Feature(
            "Soil_Type3", int, name_extended="indicator for soil type 3 designation"
        ),
        Feature(
            "Soil_Type4", int, name_extended="indicator for soil type 4 designation"
        ),
        Feature(
            "Soil_Type5", int, name_extended="indicator for soil type 5 designation"
        ),
        Feature(
            "Soil_Type6", int, name_extended="indicator for soil type 6 designation"
        ),
        Feature(
            "Soil_Type7", int, name_extended="indicator for soil type 7 designation"
        ),
        Feature(
            "Soil_Type8", int, name_extended="indicator for soil type 8 designation"
        ),
        Feature(
            "Soil_Type9", int, name_extended="indicator for soil type 9 designation"
        ),
        Feature(
            "Soil_Type10", int, name_extended="indicator for soil type 10 designation"
        ),
        Feature(
            "Soil_Type11", int, name_extended="indicator for soil type 11 designation"
        ),
        Feature(
            "Soil_Type12", int, name_extended="indicator for soil type 12 designation"
        ),
        Feature(
            "Soil_Type13", int, name_extended="indicator for soil type 13 designation"
        ),
        Feature(
            "Soil_Type14", int, name_extended="indicator for soil type 14 designation"
        ),
        Feature(
            "Soil_Type15", int, name_extended="indicator for soil type 15 designation"
        ),
        Feature(
            "Soil_Type16", int, name_extended="indicator for soil type 16 designation"
        ),
        Feature(
            "Soil_Type17", int, name_extended="indicator for soil type 17 designation"
        ),
        Feature(
            "Soil_Type18", int, name_extended="indicator for soil type 18 designation"
        ),
        Feature(
            "Soil_Type19", int, name_extended="indicator for soil type 19 designation"
        ),
        Feature(
            "Soil_Type20", int, name_extended="indicator for soil type 20 designation"
        ),
        Feature(
            "Soil_Type21", int, name_extended="indicator for soil type 21 designation"
        ),
        Feature(
            "Soil_Type22", int, name_extended="indicator for soil type 22 designation"
        ),
        Feature(
            "Soil_Type23", int, name_extended="indicator for soil type 23 designation"
        ),
        Feature(
            "Soil_Type24", int, name_extended="indicator for soil type 24 designation"
        ),
        Feature(
            "Soil_Type25", int, name_extended="indicator for soil type 25 designation"
        ),
        Feature(
            "Soil_Type26", int, name_extended="indicator for soil type 26 designation"
        ),
        Feature(
            "Soil_Type27", int, name_extended="indicator for soil type 27 designation"
        ),
        Feature(
            "Soil_Type28", int, name_extended="indicator for soil type 28 designation"
        ),
        Feature(
            "Soil_Type29", int, name_extended="indicator for soil type 29 designation"
        ),
        Feature(
            "Soil_Type30", int, name_extended="indicator for soil type 30 designation"
        ),
        Feature(
            "Soil_Type31", int, name_extended="indicator for soil type 31 designation"
        ),
        Feature(
            "Soil_Type32", int, name_extended="indicator for soil type 32 designation"
        ),
        Feature(
            "Soil_Type33", int, name_extended="indicator for soil type 33 designation"
        ),
        Feature(
            "Soil_Type34", int, name_extended="indicator for soil type 34 designation"
        ),
        Feature(
            "Soil_Type35", int, name_extended="indicator for soil type 35 designation"
        ),
        Feature(
            "Soil_Type36", int, name_extended="indicator for soil type 36 designation"
        ),
        Feature(
            "Soil_Type37", int, name_extended="indicator for soil type 37 designation"
        ),
        Feature(
            "Soil_Type38", int, name_extended="indicator for soil type 38 designation"
        ),
        Feature(
            "Soil_Type39", int, name_extended="indicator for soil type 39 designation"
        ),
        Feature(
            "Soil_Type40", int, name_extended="indicator for soil type 40 designation"
        ),
    ],
    documentation="https://archive.ics.uci.edu/dataset/31/covertype",
)

CREDIT_FULL_FEATURES = FeatureList(
    features=[
        Feature(
            "SeriousDlqin2yrs",
            int,
            is_target=True,
            name_extended="Person experienced 90 days past due delinquency or worse in past 2 years",
        ),
        Feature(
            "RevolvingUtilizationOfUnsecuredLines",
            float,
            name_extended="Total balance on credit cards and personal lines of credit except real estate and no installment debt like car loans divided by the sum of credit limits",
        ),
        Feature("age", int, name_extended="Age of borrower in years"),
        Feature(
            "NumberOfTime30-59DaysPastDueNotWorse",
            int,
            name_extended="Number of times borrower has been 30-59 days past due but no worse in the last 2 years",
        ),
        Feature(
            "DebtRatio",
            float,
            name_extended="Monthly debt payments, alimony,living costs divided by monthy gross income",
        ),
        Feature("MonthlyIncome", float, name_extended="Monthly income"),
        Feature(
            "NumberOfOpenCreditLinesAndLoans",
            int,
            name_extended="Number of Open loans (installment like car loan or mortgage) and Lines of credit (e.g. credit cards)",
        ),
        Feature(
            "NumberOfTimes90DaysLate",
            int,
            name_extended="Number of times borrower has been 90 days or more past due",
        ),
        Feature(
            "NumberRealEstateLoansOrLines",
            int,
            name_extended="Number of mortgage and real estate loans including home equity lines of credit",
        ),
        Feature(
            "NumberOfTime60-89DaysPastDueNotWorse",
            int,
            name_extended="Number of times borrower has been 60-89 days past due but no worse in the last 2 years",
        ),
        Feature(
            "NumberOfDependents",
            float,
            name_extended="Number of dependents in family excluding themselves (spouse, children etc.)",
        ),
    ],
    documentation=CREDIT_FEATURES.documentation,
)

HIGGS_FEATURES = FeatureList(
    features=[
        Feature("target", int, name_extended="is signal", is_target=True),
        Feature("lepton_pT", float, name_extended="kinematic property lepton pT"),
        Feature("lepton_eta", float, name_extended="kinematic property lepton eta"),
        Feature("lepton_phi", float, name_extended="kinematic property lepton phi"),
        Feature(
            "missing_energy_magnitude",
            float,
            name_extended="kinematic property missing energy magnitude",
        ),
        Feature(
            "missing_energy_phi",
            float,
            name_extended="kinematic property missing energy phi",
        ),
        Feature("jet_1_pt", float, name_extended="kinematic property jet 1 pT"),
        Feature("jet_1_eta", float, name_extended="kinematic property jet 1 eta"),
        Feature("jet_1_phi", float, name_extended="kinematic property jet 1 phi"),
        Feature("jet 1 b-tag", float, name_extended="kinematic property jet 1 b-tag"),
        Feature("jet_2_pt", float, name_extended="kinematic property jet 2 pT"),
        Feature("jet_2_eta", float, name_extended="kinematic property jet 2 eta"),
        Feature("jet_2_phi", float, name_extended="kinematic property jet 2 phi"),
        Feature("jet 2 b-tag", float, name_extended="kinematic property jet 2 b-tag"),
        Feature("jet_3_pt", float, name_extended="kinematic property jet 3 pT"),
        Feature("jet_3_eta", float, name_extended="kinematic property jet 3 eta"),
        Feature("jet_3_phi", float, name_extended="kinematic property jet 3 phi"),
        Feature("jet 3 b-tag", float, name_extended="kinematic property jet 3 b-tag"),
        Feature("jet_4_pt", float, name_extended="kinematic property jet 4 pT"),
        Feature("jet_4_eta", float, name_extended="kinematic property jet 4 eta"),
        Feature("jet_4_phi", float, name_extended="kinematic property jet 4 phi"),
        Feature("jet 4 b-tag", float, name_extended="kinematic property jet 4 b-tag"),
        Feature("m_jj", float, name_extended="derived feature m_jj"),
        Feature("m_jjj", float, name_extended="derived feature m_jjj"),
        Feature("m_lv", float, name_extended="derived feature m_lv"),
        Feature("m_jlv", float, name_extended="derived feature m_jlv"),
        Feature("m_bb", float, name_extended="derived feature m_bb"),
        Feature("m_wbb", float, name_extended="derived feature m_wbb"),
        Feature("m_wwbb", float, name_extended="derived feature m_wwbb"),
    ],
    documentation=HIGGS_FEATURES.documentation,
)

DEFAULT_OF_CREDIT_CLIENTS_FULL_FEATURES = FeatureList(
    [
        *[
            copy.deepcopy(f)
            for f in DEFAULT_OF_CREDIT_CLIENTS_FEATURES.features
            if f.name != "x2"
        ],
        # Grinsztajn uses 1 and 0 for gender but the original dataset uses 0/1;
        # since the Feature object is immutable we remove the preexisting
        # feature and create a new one.
        Feature(
            DEFAULT_OF_CREDIT_CLIENTS_FEATURES["x2"].name,
            DEFAULT_OF_CREDIT_CLIENTS_FEATURES["x2"].kind,
            DEFAULT_OF_CREDIT_CLIENTS_FEATURES["x2"].description,
            name_extended=DEFAULT_OF_CREDIT_CLIENTS_FEATURES["x2"].name_extended,
            value_mapping={1: "male", 2: "female"},
        ),
        Feature(
            "x3",
            int,
            value_mapping={
                0: "unknown",
                1: "graduate school",
                2: "university",
                3: "high school",
                4: "others",
                5: "unknown",
                6: "unknown",
            },
            name_extended="education level",
        ),
        Feature(
            "x4",
            int,
            name_extended="marital status",
            value_mapping={
                0: "unknown",
                1: "married",
                2: "single",
                3: "other",
            },
        ),
    ],
    documentation=DEFAULT_OF_CREDIT_CLIENTS_FEATURES.documentation,
)

ROAD_SAFETY_FULL_FEATURES = FeatureList(
    features=[
        # Feature("Accident_Index", cat_dtype),
        Feature("Vehicle_Reference_df_res", int),
        Feature(
            "Vehicle_Type",
            float,
            name_extended="vehicle type",
            value_mapping={
                1: "Pedal cycle",
                2: "Motorcycle 50cc and under",
                3: "Motorcycle 125cc and under",
                4: "Motorcycle over 125cc and up to 500cc",
                5: "Motorcycle over 500cc",
                8: "Taxi/Private hire car",
                9: "Car",
                10: "Minibus (8 - 16 passenger seats)",
                11: "Bus or coach (17 or more pass seats)",
                16: "Ridden horse",
                17: "Agricultural vehicle",
                18: "Tram",
                19: "Van / Goods 3.5 tonnes mgw or under",
                20: "Goods over 3.5t. and under 7.5t",
                21: "Goods 7.5 tonnes mgw and over",
                22: "Mobility scooter",
                23: "Electric motorcycle",
                90: "Other vehicle",
                97: "Motorcycle - unknown cc",
                98: "Goods vehicle - unknown weight",
                99: "Unknown vehicle type (self rep only)",
                103: "Motorcycle - Scooter (1979-1998)",
                104: "Motorcycle (1979-1998)",
                105: "Motorcycle - Combination (1979-1998)",
                106: "Motorcycle over 125cc (1999-2004)",
                108: "Taxi (excluding private hire cars) (1979-2004)",
                109: "Car (including private hire cars) (1979-2004)",
                110: "Minibus/Motor caravan (1979-1998)",
                113: "Goods over 3.5 tonnes (1979-1998)",
                -1: "Data missing or out of range",
            },
        ),
        Feature(
            "Towing_and_Articulation",
            float,
            name_extended="Towing and Articulation",
            value_mapping={
                0: "No tow/articulation",
                1: "Articulated vehicle",
                2: "Double or multiple trailer",
                3: "Caravan",
                4: "Single trailer",
                5: "Other tow",
                9: "unknown (self reported)",
                -1: "Data missing or out of range",
            },
        ),
        Feature(
            "Vehicle_Manoeuvre",
            float,
            name_extended="vehicle maneuver type",
            value_mapping={
                -1: "Data missing or out of range",
                1: "Reversing",
                2: "Parked",
                3: "Waiting to go - held up",
                4: "Slowing or stopping",
                5: "Moving off",
                6: "U-turn",
                7: "Turning left",
                8: "Waiting to turn left",
                9: "Turning right",
                10: "Waiting to turn right",
                11: "Changing lane to left",
                12: "Changing lane to right",
                13: "Overtaking moving vehicle - offside",
                14: "Overtaking static vehicle - offside",
                15: "Overtaking - nearside",
                16: "Going ahead left-hand bend",
                17: "Going ahead right-hand bend",
                18: "Going ahead other",
                99: "unknown (self reported)",
            },
        ),
        Feature(
            "Vehicle_Location-Restricted_Lane",
            float,
            name_extended="vehicle location lane restriction type",
            value_mapping={
                0: "On main c'way - not in restricted lane",
                1: "Tram/Light rail track",
                2: "Bus lane",
                3: "Busway (including guided busway)",
                4: "Cycle lane (on main carriageway)",
                5: "Cycleway or shared use footway (not part of  main carriageway)",
                6: "On lay-by or hard shoulder",
                7: "Entering lay-by or hard shoulder",
                8: "Leaving lay-by or hard shoulder",
                9: "Footway (pavement)",
                10: "Not on carriageway",
                99: "unknown (self reported)",
                -1: "Data missing or out of range",
            },
        ),
        Feature(
            "Junction_Location",
            float,
            name_extended="junction location",
            value_mapping={
                0: "Not at or within 20 metres of junction",
                1: "Approaching junction or waiting/parked at junction approach",
                2: "Cleared junction or waiting/parked at junction exit",
                3: "Leaving roundabout",
                4: "Entering roundabout",
                5: "Leaving main road",
                6: "Entering main road",
                7: "Entering from slip road",
                8: "Mid Junction - on roundabout or on main road",
                9: "unknown (self reported)",
                -1: "Data missing or out of range",
            },
        ),
        Feature(
            "Skidding_and_Overturning",
            float,
            name_extended="skidding and overturning",
            value_mapping={
                0: "None",
                1: "Skidded",
                2: "Skidded and overturned",
                3: "Jackknifed",
                4: "Jackknifed and overturned",
                5: "Overturned",
                9: "unknown (self reported)",
                -1: "Data missing or out of range",
            },
        ),
        Feature(
            "Hit_Object_in_Carriageway",
            float,
            name_extended="hit object in carriageway",
            value_mapping={
                0: "None",
                1: "Previous accident",
                2: "Road works",
                4: "Parked vehicle",
                5: "Bridge (roof)",
                6: "Bridge (side)",
                7: "Bollard or refuge",
                8: "Open door of vehicle",
                9: "Central island of roundabout",
                10: "Kerb",
                11: "Other object",
                12: "Any animal (except ridden horse)",
                99: "unknown (self reported)",
                -1: "Data missing or out of range",
            },
        ),
        Feature(
            "Vehicle_Leaving_Carriageway",
            float,
            name_extended="vehicle leaving carriageway",
            value_mapping={
                0: "Did not leave carriageway",
                1: "Nearside",
                2: "Nearside and rebounded",
                3: "Straight ahead at junction",
                4: "Offside on to central reservation",
                5: "Offside on to centrl res + rebounded",
                6: "Offside - crossed central reservation",
                7: "Offside",
                8: "Offside and rebounded",
                9: "unknown (self reported)",
                -1: "Data missing or out of range",
            },
        ),
        Feature(
            "Hit_Object_off_Carriageway",
            float,
            name_extended="hit object off carriageway",
            value_mapping={
                0: "None",
                1: "Road sign or traffic signal",
                2: "Lamp post",
                3: "Telegraph or electricity pole",
                4: "Tree",
                5: "Bus stop or bus shelter",
                6: "Central crash barrier",
                7: "Near/Offside crash barrier",
                8: "Submerged in water",
                9: "Entered ditch",
                10: "Other permanent object",
                11: "Wall or fence",
                99: "unknown (self reported)",
                -1: "Data missing or out of range",
            },
        ),
        Feature(
            "1st_Point_of_Impact",
            float,
            name_extended="first point of impact",
            value_mapping={
                0: "Did not impact",
                1: "Front",
                2: "Back",
                3: "Offside",
                4: "Nearside",
                9: "unknown (self reported)",
                -1: "Data missing or out of range",
            },
        ),
        Feature(
            "Was_Vehicle_Left_Hand_Drive?",
            float,
            name_extended="indicator for whether vehicle was left-hand drive",
            value_mapping={
                1: "No",
                2: "Yes",
                9: "Unknown",
                -1: "Data missing or out of range",
            },
        ),
        Feature(
            "Journey_Purpose_of_Driver",
            float,
            name_extended="Journey purpose of driver",
            value_mapping={
                1: "Journey as part of work",
                2: "Commuting to/from work",
                3: "Taking pupil to/from school",
                4: "Pupil riding to/from school",
                5: "Other",
                6: "Not known",
                15: "Other/Not known",
                -1: "Data missing or out of range",
            },
        ),
        Feature(
            "Sex_of_Driver",
            cat_dtype,
            is_target=True,
            # value_mapping={
            #     1: "Male",
            #     2: "Female",
            #     3: "Not known",
            #     -1: "Data missing or out of range",
            # },
        ),
        Feature("Age_of_Driver", float, name_extended="age of driver (in years)"),
        Feature(
            "Age_Band_of_Driver",
            float,
            name_extended="age band of driver",
            value_mapping={
                1: "0 - 5",
                2: "6 - 10",
                3: "11 - 15",
                4: "16 - 20",
                5: "21 - 25",
                6: "26 - 35",
                7: "36 - 45",
                8: "46 - 55",
                9: "56 - 65",
                10: "66 - 75",
                11: "Over 75",
            },
        ),
        Feature("Engine_Capacity_(CC)", float, name_extended="engine capacity in cc"),
        Feature(
            "Propulsion_Code",
            float,
            name_extended="propulsion code",
            value_mapping={
                1: "Petrol",
                2: "Heavy oil",
                3: "Electric",
                4: "Steam",
                5: "Gas",
                6: "Petrol/Gas (LPG)",
                7: "Gas/Bi-fuel",
                8: "Hybrid electric",
                9: "Gas Diesel",
                10: "New fuel technology",
                11: "Fuel cells",
                12: "Electric diesel",
                -1: "Undefined",
            },
        ),
        Feature("Age_of_Vehicle", float, name_extended="age of vehicle in years"),
        Feature(
            "Driver_Home_Area_Type",
            float,
            name_extended="driver home area type",
            value_mapping={
                1: "Urban area",
                2: "Small town",
                3: "Rural",
                -1: "Data missing or out of range",
            },
        ),
        Feature(
            "Location_Easting_OSGR",
            float,
            name_extended="Ordnance Survey Grid References (OSGR) Easting coordinate",
        ),
        Feature(
            "Location_Northing_OSGR",
            float,
            name_extended="Ordnance Survey Grid References (OSGR) Northing coordinate",
        ),
        Feature("Longitude", float),
        Feature("Latitude", float),
        Feature(
            "Police_Force",
            float,
            name_extended="police force code",
            value_mapping={
                1: "Metropolitan Police",
                3: "Cumbria",
                4: "Lancashire",
                5: "Merseyside",
                6: "Greater Manchester",
                7: "Cheshire",
                10: "Northumbria",
                11: "Durham",
                12: "North Yorkshire",
                13: "West Yorkshire",
                14: "South Yorkshire",
                16: "Humberside",
                17: "Cleveland",
                20: "West Midlands",
                21: "Staffordshire",
                22: "West Mercia",
                23: "Warwickshire",
                30: "Derbyshire",
                31: "Nottinghamshire",
                32: "Lincolnshire",
                33: "Leicestershire",
                34: "Northamptonshire",
                35: "Cambridgeshire",
                36: "Norfolk",
                37: "Suffolk",
                40: "Bedfordshire",
                41: "Hertfordshire",
                42: "Essex",
                43: "Thames Valley",
                44: "Hampshire",
                45: "Surrey",
                46: "Kent",
                47: "Sussex",
                48: "City of London",
                50: "Devon and Cornwall",
                52: "Avon and Somerset",
                53: "Gloucestershire",
                54: "Wiltshire",
                55: "Dorset",
                60: "North Wales",
                61: "Gwent",
                62: "South Wales",
                63: "Dyfed-Powys",
                91: "Northern",
                92: "Grampian",
                93: "Tayside",
                94: "Fife",
                95: "Lothian and Borders",
                96: "Central",
                97: "Strathclyde",
                98: "Dumfries and Galloway",
                99: "Police Scotland",
            },
        ),
        Feature(
            "Accident_Severity",
            float,
            name_extended="accident severity",
            value_mapping={
                1: "Fatal",
                2: "Serious",
                3: "Slight",
            },
        ),
        Feature(
            "Number_of_Vehicles", float, name_extended="number of vehicles involved"
        ),
        Feature("Number_of_Casualties", float, name_extended="number of casualties"),
        Feature("Date", cat_dtype),
        Feature("Day_of_Week", float),
        Feature("Time", cat_dtype),
        Feature(
            "Local_Authority_(District)",
            float,
            name_extended="local authority (district)",
            value_mapping={
                1: "Westminster",
                2: "Camden",
                3: "Islington",
                4: "Hackney",
                5: "Tower Hamlets",
                6: "Greenwich",
                7: "Lewisham",
                8: "Southwark",
                9: "Lambeth",
                10: "Wandsworth",
                11: "Hammersmith and Fulham",
                12: "Kensington and Chelsea",
                13: "Waltham Forest",
                14: "Redbridge",
                15: "Havering",
                16: "Barking and Dagenham",
                17: "Newham",
                18: "Bexley",
                19: "Bromley",
                20: "Croydon",
                21: "Sutton",
                22: "Merton",
                23: "Kingston upon Thames",
                24: "Richmond upon Thames",
                25: "Hounslow",
                26: "Hillingdon",
                27: "Ealing",
                28: "Brent",
                29: "Harrow",
                30: "Barnet",
                31: "Haringey",
                32: "Enfield",
                33: "Hertsmere",
                38: "Epsom and Ewell",
                40: "Spelthorne",
                57: "London Airport (Heathrow)",
                60: "Allerdale",
                61: "Barrow-in-Furness",
                62: "Carlisle",
                63: "Copeland",
                64: "Eden",
                65: "South Lakeland",
                70: "Blackburn with Darwen",
                71: "Blackpool",
                72: "Burnley",
                73: "Chorley",
                74: "Fylde",
                75: "Hyndburn",
                76: "Lancaster",
                77: "Pendle",
                79: "Preston",
                80: "Ribble Valley",
                82: "Rossendale",
                83: "South Ribble",
                84: "West Lancashire",
                85: "Wyre",
                90: "Knowsley",
                91: "Liverpool",
                92: "St. Helens",
                93: "Sefton",
                95: "Wirral",
                100: "Bolton",
                101: "Bury",
                102: "Manchester",
                104: "Oldham",
                106: "Rochdale",
                107: "Salford",
                109: "Stockport",
                110: "Tameside",
                112: "Trafford",
                114: "Wigan",
                120: "Chester",
                121: "Congleton",
                122: "Crewe and Nantwich",
                123: "Ellesmere Port and Neston",
                124: "Halton",
                126: "Macclesfield",
                127: "Vale Royal",
                128: "Warrington",
                129: "Cheshire East",
                130: "Cheshire West and Chester",
                139: "Northumberland",
                140: "Alnwick",
                141: "Berwick-upon-Tweed",
                142: "Blyth Valley",
                143: "Castle Morpeth",
                144: "Tynedale",
                145: "Wansbeck",
                146: "Gateshead",
                147: "Newcastle upon Tyne",
                148: "North Tyneside",
                149: "South Tyneside",
                150: "Sunderland",
                160: "Chester-le-Street",
                161: "Darlington",
                162: "Derwentside",
                163: "Durham",
                164: "Easington",
                165: "Sedgefield",
                166: "Teesdale",
                168: "Wear Valley",
                169: "County Durham",
                180: "Craven",
                181: "Hambleton",
                182: "Harrogate",
                184: "Richmondshire",
                185: "Ryedale",
                186: "Scarborough",
                187: "Selby",
                189: "York",
                200: "Bradford",
                202: "Calderdale",
                203: "Kirklees",
                204: "Leeds",
                206: "Wakefield",
                210: "Barnsley",
                211: "Doncaster",
                213: "Rotherham",
                215: "Sheffield",
                228: "Kingston upon Hull, City of",
                231: "East Riding of Yorkshire",
                232: "North Lincolnshire",
                233: "North East Lincolnshire",
                240: "Hartlepool",
                241: "Redcar and Cleveland",
                243: "Middlesbrough",
                245: "Stockton-on-Tees",
                250: "Cannock Chase",
                251: "East Staffordshire",
                252: "Lichfield",
                253: "Newcastle-under-Lyme",
                254: "South Staffordshire",
                255: "Stafford",
                256: "Staffordshire Moorlands",
                257: "Stoke-on-Trent",
                258: "Tamworth",
                270: "Bromsgrove",
                273: "Malvern Hills",
                274: "Redditch",
                276: "Worcester",
                277: "Wychavon",
                278: "Wyre Forest",
                279: "Bridgnorth",
                280: "North Shropshire",
                281: "Oswestry",
                282: "Shrewsbury and Atcham",
                283: "South Shropshire",
                284: "Telford and Wrekin",
                285: "Herefordshire, County of",
                286: "Shropshire",
                290: "North Warwickshire",
                291: "Nuneaton and Bedworth",
                292: "Rugby",
                293: "Stratford-upon-Avon",
                294: "Warwick",
                300: "Birmingham",
                302: "Coventry",
                303: "Dudley",
                305: "Sandwell",
                306: "Solihull",
                307: "Walsall",
                309: "Wolverhampton",
                320: "Amber Valley",
                321: "Bolsover",
                322: "Chesterfield",
                323: "Derby",
                324: "Erewash",
                325: "High Peak",
                327: "North East Derbyshire",
                328: "South Derbyshire",
                329: "Derbyshire Dales",
                340: "Ashfield",
                341: "Bassetlaw",
                342: "Broxtowe",
                343: "Gedling",
                344: "Mansfield",
                345: "Newark and Sherwood",
                346: "Nottingham",
                347: "Rushcliffe",
                350: "Boston",
                351: "East Lindsey",
                352: "Lincoln",
                353: "North Kesteven",
                354: "South Holland",
                355: "South Kesteven",
                356: "West Lindsey",
                360: "Blaby",
                361: "Hinckley and Bosworth",
                362: "Charnwood",
                363: "Harborough",
                364: "Leicester",
                365: "Melton",
                366: "North West Leicestershire",
                367: "Oadby and Wigston",
                368: "Rutland",
                380: "Corby",
                381: "Daventry",
                382: "East Northamptonshire",
                383: "Kettering",
                384: "Northampton",
                385: "South Northamptonshire",
                386: "Wellingborough",
                390: "Cambridge",
                391: "East Cambridgeshire",
                392: "Fenland",
                393: "Huntingdonshire",
                394: "Peterborough",
                395: "South Cambridgeshire",
                400: "Breckland",
                401: "Broadland",
                402: "Great Yarmouth",
                404: "Norwich",
                405: "North Norfolk",
                406: "South Norfolk",
                407: "King's Lynn and West Norfolk",
                410: "Babergh",
                411: "Forest Heath",
                412: "Ipswich",
                413: "Mid Suffolk",
                414: "St. Edmundsbury",
                415: "Suffolk Coastal",
                416: "Waveney",
                420: "Bedford",
                421: "Luton",
                422: "Mid Bedfordshire",
                423: "South Bedfordshire",
                424: "Central Bedfordshire",
                430: "Broxbourne",
                431: "Dacorum",
                432: "East Hertfordshire",
                433: "North Hertfordshire",
                434: "St. Albans",
                435: "Stevenage",
                436: "Three Rivers",
                437: "Watford",
                438: "Welwyn Hatfield",
                450: "Basildon",
                451: "Braintree",
                452: "Brentwood",
                453: "Castle Point",
                454: "Chelmsford",
                455: "Colchester",
                456: "Epping Forest",
                457: "Harlow",
                458: "Maldon",
                459: "Rochford",
                460: "Southend-on-Sea",
                461: "Tendring",
                462: "Thurrock",
                463: "Uttlesford",
                470: "Bracknell Forest",
                471: "West Berkshire",
                472: "Reading",
                473: "Slough",
                474: "Windsor and Maidenhead",
                475: "Wokingham",
                476: "Aylesbury Vale",
                477: "South Bucks",
                478: "Chiltern",
                479: "Milton Keynes",
                480: "Wycombe",
                481: "Cherwell",
                482: "Oxford",
                483: "Vale of White Horse",
                484: "South Oxfordshire",
                485: "West Oxfordshire",
                490: "Basingstoke and Deane",
                491: "Eastleigh",
                492: "Fareham",
                493: "Gosport",
                494: "Hart",
                495: "Havant",
                496: "New Forest",
                497: "East Hampshire",
                498: "Portsmouth",
                499: "Rushmoor",
                500: "Southampton",
                501: "Test Valley",
                502: "Winchester",
                505: "Isle of Wight",
                510: "Elmbridge",
                511: "Guildford",
                512: "Mole Valley",
                513: "Reigate and Banstead",
                514: "Runnymede",
                515: "Surrey Heath",
                516: "Tandridge",
                517: "Waverley",
                518: "Woking",
                530: "Ashford",
                531: "Canterbury",
                532: "Dartford",
                533: "Dover",
                535: "Gravesham",
                536: "Maidstone",
                538: "Sevenoaks",
                539: "Shepway",
                540: "Swale",
                541: "Thanet",
                542: "Tonbridge and Malling",
                543: "Tunbridge Wells",
                544: "Medway",
                551: "Eastbourne",
                552: "Hastings",
                554: "Lewes",
                555: "Rother",
                556: "Wealden",
                557: "Adur",
                558: "Arun",
                559: "Chichester",
                560: "Crawley",
                562: "Horsham",
                563: "Mid Sussex",
                564: "Worthing",
                565: "Brighton and Hove",
                570: "City of London",
                580: "East Devon",
                581: "Exeter",
                582: "North Devon",
                583: "Plymouth",
                584: "South Hams",
                585: "Teignbridge",
                586: "Mid Devon",
                587: "Torbay",
                588: "Torridge",
                589: "West Devon",
                590: "Caradon",
                591: "Carrick",
                592: "Kerrier",
                593: "North Cornwall",
                594: "Penwith",
                595: "Restormel",
                596: "Cornwall",
                601: "Bristol, City of",
                605: "North Somerset",
                606: "Mendip",
                607: "Sedgemoor",
                608: "Taunton Deane",
                609: "West Somerset",
                610: "South Somerset",
                611: "Bath and North East Somerset",
                612: "South Gloucestershire",
                620: "Cheltenham",
                621: "Cotswold",
                622: "Forest of Dean",
                623: "Gloucester",
                624: "Stroud",
                625: "Tewkesbury",
                630: "Kennet",
                631: "North Wiltshire",
                632: "Salisbury",
                633: "Swindon",
                634: "West Wiltshire",
                635: "Wiltshire",
                640: "Bournemouth",
                641: "Christchurch",
                642: "North Dorset",
                643: "Poole",
                644: "Purbeck",
                645: "West Dorset",
                646: "Weymouth and Portland",
                647: "East Dorset",
                720: "Isle of Anglesey",
                721: "Conwy",
                722: "Gwynedd",
                723: "Denbighshire",
                724: "Flintshire",
                725: "Wrexham",
                730: "Blaenau Gwent",
                731: "Caerphilly",
                732: "Monmouthshire",
                733: "Newport",
                734: "Torfaen",
                740: "Bridgend",
                741: "Cardiff",
                742: "Merthyr Tydfil",
                743: "Neath Port Talbot",
                744: "Rhondda, Cynon, Taff",
                745: "Swansea",
                746: "The Vale of Glamorgan",
                750: "Ceredigion",
                751: "Carmarthenshire",
                752: "Pembrokeshire",
                753: "Powys",
                910: "Aberdeen City",
                911: "Aberdeenshire",
                912: "Angus",
                913: "Argyll and Bute",
                914: "Scottish Borders",
                915: "Clackmannanshire",
                916: "West Dunbartonshire",
                917: "Dumfries and Galloway",
                918: "Dundee City",
                919: "East Ayrshire",
                920: "East Dunbartonshire",
                921: "East Lothian",
                922: "East Renfrewshire",
                923: "Edinburgh, City of",
                924: "Falkirk",
                925: "Fife",
                926: "Glasgow City",
                927: "Highland",
                928: "Inverclyde",
                929: "Midlothian",
                930: "Moray",
                931: "North Ayrshire",
                932: "North Lanarkshire",
                933: "Orkney Islands",
                934: "Perth and Kinross",
                935: "Renfrewshire",
                936: "Shetland Islands",
                937: "South Ayrshire",
                938: "South Lanarkshire",
                939: "Stirling",
                940: "West Lothian",
                941: "Western Isles",
            },
        ),
        Feature(
            "Local_Authority_(Highway)",
            cat_dtype,
            name_extended="local authority (highway)",
            value_mapping={
                "E06000001": "Hartlepool",
                "E06000002": "Middlesbrough",
                "E06000003": "Redcar and Cleveland",
                "E06000004": "Stockton-on-Tees",
                "E06000005": "Darlington",
                "E06000006": "Halton",
                "E06000007": "Warrington",
                "E06000008": "Blackburn with Darwen",
                "E06000009": "Blackpool",
                "E06000010": "Kingston upon Hull, City of",
                "E06000011": "East Riding of Yorkshire",
                "E06000012": "North East Lincolnshire",
                "E06000013": "North Lincolnshire",
                "E06000014": "York",
                "E06000015": "Derby",
                "E06000016": "Leicester",
                "E06000017": "Rutland",
                "E06000018": "Nottingham",
                "E06000019": "Herefordshire, County of ",
                "E06000020": "Telford and Wrekin",
                "E06000021": "Stoke-on-Trent",
                "E06000022": "Bath and North East Somerset",
                "E06000023": "Bristol, City of",
                "E06000024": "North Somerset",
                "E06000025": "South Gloucestershire",
                "E06000026": "Plymouth",
                "E06000027": "Torbay",
                "E06000028": "Bournemouth",
                "E06000029": "Poole",
                "E06000030": "Swindon",
                "E06000031": "Peterborough",
                "E06000032": "Luton",
                "E06000033": "Southend-on-Sea",
                "E06000034": "Thurrock",
                "E06000035": "Medway",
                "E06000036": "Bracknell Forest",
                "E06000037": "West Berkshire",
                "E06000038": "Reading",
                "E06000039": "Slough",
                "E06000040": "Windsor and Maidenhead",
                "E06000041": "Wokingham",
                "E06000042": "Milton Keynes",
                "E06000043": "Brighton and Hove",
                "E06000044": "Portsmouth",
                "E06000045": "Southampton ",
                "E06000046": "Isle of Wight",
                "E06000047": "County Durham",
                "E06000048": "Northumberland",
                "E06000049": "Cheshire East",
                "E06000050": "Cheshire West and Chester",
                "E06000051": "Shropshire",
                "E06000052": "Cornwall",
                "E06000053": "Isles of Scilly",
                "E06000054": "Wiltshire",
                "E06000055": "Bedford",
                "E06000056": "Central Bedfordshire",
                "E06000057": "Northumberland",
                "E06000058": "Bournemouth, Christchurch and Poole",
                "E06000059": "Dorset (excluding Christchurch)",
                "E06000060": "Buckinghamshire",
                "E06000061": "North Northamptonshire",
                "E06000062": "West Northamptonshire",
                "E08000001": "Bolton",
                "E08000002": "Bury",
                "E08000003": "Manchester",
                "E08000004": "Oldham",
                "E08000005": "Rochdale",
                "E08000006": "Salford",
                "E08000007": "Stockport",
                "E08000008": "Tameside",
                "E08000009": "Trafford",
                "E08000010": "Wigan",
                "E08000011": "Knowsley",
                "E08000012": "Liverpool",
                "E08000013": "St. Helens",
                "E08000014": "Sefton",
                "E08000015": "Wirral",
                "E08000016": "Barnsley",
                "E08000017": "Doncaster",
                "E08000018": "Rotherham",
                "E08000019": "Sheffield",
                "E08000020": "Gateshead",
                "E08000021": "Newcastle upon Tyne",
                "E08000022": "North Tyneside",
                "E08000023": "South Tyneside",
                "E08000024": "Sunderland",
                "E08000025": "Birmingham",
                "E08000026": "Coventry",
                "E08000027": "Dudley",
                "E08000028": "Sandwell",
                "E08000029": "Solihull",
                "E08000030": "Walsall",
                "E08000031": "Wolverhampton",
                "E08000032": "Bradford",
                "E08000033": "Calderdale",
                "E08000034": "Kirklees",
                "E08000035": "Leeds",
                "E08000037": "Gateshead",
                "E08000036": "Wakefield",
                "E09000001": "City of London",
                "E09000002": "Barking and Dagenham",
                "E09000003": "Barnet",
                "E09000004": "Bexley",
                "E09000005": "Brent",
                "E09000006": "Bromley",
                "E09000007": "Camden",
                "E09000008": "Croydon",
                "E09000009": "Ealing",
                "E09000010": "Enfield",
                "E09000011": "Greenwich",
                "E09000012": "Hackney",
                "E09000013": "Hammersmith and Fulham",
                "E09000014": "Haringey",
                "E09000015": "Harrow",
                "E09000016": "Havering",
                "E09000017": "Hillingdon",
                "E09000018": "Hounslow",
                "E09000019": "Islington",
                "E09000020": "Kensington and Chelsea",
                "E09000021": "Kingston upon Thames",
                "E09000022": "Lambeth",
                "E09000023": "Lewisham",
                "E09000024": "Merton",
                "E09000025": "Newham",
                "E09000026": "Redbridge",
                "E09000027": "Richmond upon Thames",
                "E09000028": "Southwark",
                "E09000029": "Sutton",
                "E09000030": "Tower Hamlets",
                "E09000031": "Waltham Forest",
                "E09000032": "Wandsworth",
                "E09000033": "Westminster",
                "E10000002": "Buckinghamshire",
                "E10000003": "Cambridgeshire",
                "E10000006": "Cumbria",
                "E10000007": "Derbyshire",
                "E10000008": "Devon",
                "E10000009": "Dorset",
                "E10000011": "East Sussex",
                "E10000012": "Essex",
                "E10000013": "Gloucestershire",
                "E10000014": "Hampshire",
                "E10000015": "Hertfordshire",
                "E10000016": "Kent",
                "E10000017": "Lancashire",
                "E10000018": "Leicestershire",
                "E10000019": "Lincolnshire",
                "E10000020": "Norfolk",
                "E10000021": "Northamptonshire",
                "E10000023": "North Yorkshire",
                "E10000024": "Nottinghamshire",
                "E10000025": "Oxfordshire",
                "E10000027": "Somerset",
                "E10000028": "Staffordshire",
                "E10000029": "Suffolk",
                "E10000030": "Surrey",
                "E10000031": "Warwickshire",
                "E10000032": "West Sussex",
                "E10000034": "Worcestershire",
                "EHEATHROW": "London Airport (Heathrow)",
                "S12000005": "Clackmannanshire",
                "S12000006": "Dumfries & Galloway",
                "S12000008": "East Ayrshire",
                "S12000009": "East Dunbartonshire",
                "S12000010": "East Lothian",
                "S12000011": "East Renfrewshire",
                "S12000013": "Na h-Eileanan an Iar (Western Isles)",
                "S12000014": "Falkirk",
                "S12000015": "Fife",
                "S12000017": "Highland",
                "S12000018": "Inverclyde",
                "S12000019": "Midlothian",
                "S12000020": "Moray",
                "S12000021": "North Ayrshire",
                "S12000023": "Orkney Islands",
                "S12000024": "Perth and Kinross",
                "S12000026": "Scottish Borders",
                "S12000027": "Shetland Islands",
                "S12000028": "South Ayrshire",
                "S12000029": "South Lanarkshire",
                "S12000030": "Stirling",
                "S12000033": "Aberdeen City",
                "S12000034": "Aberdeenshire",
                "S12000035": "Argyll & Bute",
                "S12000036": "Edinburgh, City of",
                "S12000038": "Renfrewshire",
                "S12000039": "West Dunbartonshire",
                "S12000040": "West Lothian",
                "S12000041": "Angus",
                "S12000042": "Dundee City",
                "S12000043": "Glasgow City",
                "S12000044": "North Lanarkshire",
                "S12000045": "East Dunbartonshire",
                "S12000047": "Fife",
                "S12000048": "Perth and Kinross",
                "S12000049": "Glasgow City",
                "S12000050": "North Lanarkshire",
                "W06000001": "Isle of Anglesey",
                "W06000002": "Gwynedd",
                "W06000003": "Conwy",
                "W06000004": "Denbighshire",
                "W06000005": "Flintshire",
                "W06000006": "Wrexham",
                "W06000008": "Ceredigion",
                "W06000009": "Pembrokeshire",
                "W06000010": "Carmarthenshire",
                "W06000011": "Swansea",
                "W06000012": "Neath Port Talbot",
                "W06000013": "Bridgend",
                "W06000014": "The Vale of Glamorgan",
                "W06000015": "Cardiff",
                "W06000016": "Rhondda, Cynon, Taff",
                "W06000018": "Caerphilly",
                "W06000019": "Blaenau Gwent",
                "W06000020": "Torfaen",
                "W06000021": "Monmouthshire",
                "W06000022": "Newport",
                "W06000023": "Powys",
                "W06000024": "Merthyr Tydfil",
                -1: "Record predates use of local_authority_highway codes",
            },
        ),
        Feature(
            "1st_Road_Class",
            float,
            name_extended="first road class",
            value_mapping={
                1: "Motorway",
                2: "A(M)",
                3: "A",
                4: "B",
                5: "C",
                6: "Unclassified",
                -1: "Data missing or out of range",
            },
        ),
        Feature(
            "1st_Road_Number",
            float,
            name_extended="first road number",
            value_mapping={
                **{x: str(x) for x in range(10000)},
                0: "no official number",
                -1: "unknown",
            },
        ),
        Feature(
            "Road_Type",
            float,
            name_extended="road type",
            value_mapping={
                1: "Roundabout",
                2: "One way street",
                3: "Dual carriageway",
                6: "Single carriageway",
                7: "Slip road",
                9: "Unknown",
                12: "One way street/Slip road",
                -1: "Data missing or out of range",
            },
        ),
        Feature("Speed_limit", float),
        Feature(
            "Junction_Detail",
            float,
            name_extended="junction detail",
            value_mapping={
                0: "Not at junction or within 20 metres",
                1: "Roundabout",
                2: "Mini-roundabout",
                3: "T or staggered junction",
                5: "Slip road",
                6: "Crossroads",
                7: "More than 4 arms (not roundabout)",
                8: "Private drive or entrance",
                9: "Other junction",
                99: "unknown (self reported)",
                -1: "Data missing or out of range",
            },
        ),
        Feature(
            "Junction_Control",
            float,
            name_extended="junction control",
            value_mapping={
                0: "Not at junction or within 20 metres",
                1: "Authorised person",
                2: "Auto traffic signal",
                3: "Stop sign",
                4: "Give way or uncontrolled",
                -1: "Data missing or out of range",
                9: "unknown (self reported)",
            },
        ),
        Feature(
            "2nd_Road_Class",
            float,
            name_extended="second road class",
            value_mapping={
                0: "Not at junction or within 20 metres",
                1: "Motorway",
                2: "A(M)",
                3: "A",
                4: "B",
                5: "C",
                6: "Unclassified",
                9: "Unknown (self rep only)",
                -1: "Data missing or out of range",
            },
        ),
        Feature(
            "2nd_Road_Number",
            float,
            name_extended="second roat number",
            value_mapping={
                **{x: str(x) for x in range(10000)},
                0: "no official number",
                -1: "unknown",
            },
        ),
        Feature(
            "Pedestrian_Crossing-Human_Control",
            float,
            name_extended="pedestrian crossing - human control",
            value_mapping={
                0: "None within 50 metres ",
                1: "Control by school crossing patrol",
                2: "Control by other authorised person",
                -1: "Data missing or out of range",
                9: "unknown (self reported)",
            },
        ),
        Feature(
            "Pedestrian_Crossing-Physical_Facilities",
            float,
            name_extended="pedestrian crossing - physical facilities",
            value_mapping={
                0: "No physical crossing facilities within 50 metres",
                1: "Zebra",
                4: "Pelican, puffin, toucan or similar non-junction pedestrian light crossing",
                5: "Pedestrian phase at traffic signal junction",
                7: "Footbridge or subway",
                8: "Central refuge",
                -1: "Data missing or out of range",
                9: "unknown (self reported)",
            },
        ),
        Feature(
            "Light_Conditions",
            float,
            name_extended="light conditions",
            value_mapping={
                1: "Daylight",
                4: "Darkness - lights lit",
                5: "Darkness - lights unlit",
                6: "Darkness - no lighting",
                7: "Darkness - lighting unknown",
                -1: "Data missing or out of range",
            },
        ),
        Feature(
            "Weather_Conditions",
            float,
            name_extended="weather conditions",
            value_mapping={
                1: "Fine no high winds",
                2: "Raining no high winds",
                3: "Snowing no high winds",
                4: "Fine + high winds",
                5: "Raining + high winds",
                6: "Snowing + high winds",
                7: "Fog or mist",
                8: "Other",
                9: "Unknown",
                -1: "Data missing or out of range",
            },
        ),
        Feature(
            "Road_Surface_Conditions",
            float,
            name_extended="road surface conditions",
            value_mapping={
                1: "Dry",
                2: "Wet or damp",
                3: "Snow",
                4: "Frost or ice",
                5: "Flood over 3cm. deep",
                6: "Oil or diesel",
                7: "Mud",
                -1: "Data missing or out of range",
                9: "unknown (self reported)",
            },
        ),
        Feature(
            "Special_Conditions_at_Site",
            float,
            name_extended="special conditions at site",
            value_mapping={
                0: "None",
                1: "Auto traffic signal - out",
                2: "Auto signal part defective",
                3: "Road sign or marking defective or obscured",
                4: "Roadworks",
                5: "Road surface defective",
                6: "Oil or diesel",
                7: "Mud",
                -1: "Data missing or out of range",
                9: "unknown (self reported)",
            },
        ),
        Feature(
            "Carriageway_Hazards",
            float,
            name_extended="carriageway hazards",
            value_mapping={
                0: "None",
                1: "Vehicle load on road",
                2: "Other object on road",
                3: "Previous accident",
                4: "Dog on road",
                5: "Other animal on road",
                6: "Pedestrian in carriageway - not injured",
                7: "Any animal in carriageway (except ridden horse)",
                -1: "Data missing or out of range",
                9: "unknown (self reported)",
            },
        ),
        Feature(
            "Urban_or_Rural_Area",
            float,
            name_extended="urban or rural area indicator",
            value_mapping={
                1: "Urban",
                2: "Rural",
                3: "Unallocated",
                -1: "Data missing or out of range",
            },
        ),
        Feature(
            "Did_Police_Officer_Attend_Scene_of_Accident",
            float,
            name_extended="did police officer attend scene of accident",
            value_mapping={
                1: "Yes",
                2: "No",
                3: "No - accident was reported using a self completion  form (self rep only)",
                -1: "Data missing or out of range",
            },
        ),
        Feature("LSOA_of_Accident_Location", cat_dtype),
        # Feature("Vehicle_Reference_df", int,
        #         name_extended='unique value for each vehicle in a singular accident'),
        # Feature("Casualty_Reference", int),
        Feature(
            "Casualty_Class",
            int,
            name_extended="casualty class",
            value_mapping={
                1: "Driver or rider",
                2: "Passenger",
                3: "Pedestrian",
            },
        ),
        Feature(
            "Sex_of_Casualty",
            float,
            name_extended="sex of casualty",
            value_mapping={
                1: "Male",
                2: "Female",
                9: "unknown (self reported)",
                -1: "Data missing or out of range",
            },
        ),
        Feature("Age_of_Casualty", float, name_extended="age of casualty in years"),
        Feature(
            "Age_Band_of_Casualty",
            float,
            name_extended="age band of casualty",
            value_mapping={
                1: "0 - 5",
                2: "6 - 10",
                3: "11 - 15",
                4: "16 - 20",
                5: "21 - 25",
                6: "26 - 35",
                7: "36 - 45",
                8: "46 - 55",
                9: "56 - 65",
                10: "66 - 75",
                11: "Over 75",
            },
        ),
        Feature(
            "Casualty_Severity",
            int,
            name_extended="casualty severity",
            value_mapping={
                1: "Fatal",
                2: "Serious",
                3: "Slight",
            },
        ),
        Feature(
            "Pedestrian_Location",
            float,
            name_extended="pedestrian location",
            value_mapping={
                0: "Not a Pedestrian",
                1: "Crossing on pedestrian crossing facility",
                2: "Crossing in zig-zag approach lines",
                3: "Crossing in zig-zag exit lines",
                4: "Crossing elsewhere within 50m. of pedestrian crossing",
                5: "In carriageway, crossing elsewhere",
                6: "On footway or verge",
                7: "On refuge, central island or central reservation",
                8: "In centre of carriageway - not on refuge, island or central reservation",
                9: "In carriageway, not crossing",
                10: "Unknown or other",
                -1: "Data missing or out of range",
            },
        ),
        Feature(
            "Pedestrian_Movement",
            float,
            name_extended="pedestrian movement",
            value_mapping={
                0: "Not a Pedestrian",
                1: "Crossing from driver's nearside",
                2: "Crossing from nearside - masked by parked or stationary vehicle",
                3: "Crossing from driver's offside",
                4: "Crossing from offside - masked by  parked or stationary vehicle",
                5: "In carriageway, stationary - not crossing  (standing or playing)",
                6: "In carriageway, stationary - not crossing  (standing or playing) - masked by parked or stationary vehicle",
                7: "Walking along in carriageway, facing traffic",
                8: "Walking along in carriageway, back to traffic",
                9: "Unknown or other",
                -1: "Data missing or out of range",
            },
        ),
        Feature(
            "Car_Passenger",
            float,
            name_extended="car passenger",
            value_mapping={
                0: "Not car passenger",
                1: "Front seat passenger",
                2: "Rear seat passenger",
                9: "unknown (self reported)",
                -1: "Data missing or out of range",
            },
        ),
        Feature(
            "Bus_or_Coach_Passenger",
            float,
            name_extended="bus or coach passenger",
            value_mapping={
                0: "Not a bus or coach passenger",
                1: "Boarding",
                2: "Alighting",
                3: "Standing passenger",
                4: "Seated passenger",
                9: "unknown (self reported)",
                -1: "Data missing or out of range",
            },
        ),
        Feature(
            "Pedestrian_Road_Maintenance_Worker",
            float,
            name_extended="pedestrian is road maintenance worker",
            value_mapping={
                0: "No / Not applicable",
                1: "Yes",
                2: "Not Known",
                3: "Probable",
                -1: "Data missing or out of range",
            },
        ),
        Feature(
            "Casualty_Type",
            int,
            name_extended="casualty type",
            value_mapping={
                0: "Pedestrian",
                1: "Cyclist",
                2: "Motorcycle 50cc and under rider or passenger",
                3: "Motorcycle 125cc and under rider or passenger",
                4: "Motorcycle over 125cc and up to 500cc rider or  passenger",
                5: "Motorcycle over 500cc rider or passenger",
                8: "Taxi/Private hire car occupant",
                9: "Car occupant",
                10: "Minibus (8 - 16 passenger seats) occupant",
                11: "Bus or coach occupant (17 or more pass seats)",
                16: "Horse rider",
                17: "Agricultural vehicle occupant",
                18: "Tram occupant",
                19: "Van / Goods vehicle (3.5 tonnes mgw or under) occupant",
                20: "Goods vehicle (over 3.5t. and under 7.5t.) occupant",
                21: "Goods vehicle (7.5 tonnes mgw and over) occupant",
                22: "Mobility scooter rider",
                23: "Electric motorcycle rider or passenger",
                90: "Other vehicle occupant",
                97: "Motorcycle - unknown cc rider or passenger",
                98: "Goods vehicle (unknown weight) occupant",
                99: "Unknown vehicle type (self rep only)",
                103: "Motorcycle - Scooter (1979-1998)",
                104: "Motorcycle (1979-1998)",
                105: "Motorcycle - Combination (1979-1998)",
                106: "Motorcycle over 125cc (1999-2004)",
                108: "Taxi (excluding private hire cars) (1979-2004)",
                109: "Car (including private hire cars) (1979-2004)",
                110: "Minibus/Motor caravan (1979-1998)",
                113: "Goods over 3.5 tonnes (1979-1998)",
            },
        ),
        Feature(
            "Casualty_Home_Area_Type",
            float,
            name_extended="casualty home area type",
            value_mapping={
                1: "Urban area",
                2: "Small town",
                3: "Rural",
                -1: "Data missing or out of range",
            },
        ),
        Feature(
            "Casualty_IMD_Decile",
            float,
            name_extended="casualty IMD decile",
            value_mapping={
                1: "Most deprived 10%",
                2: "More deprived 10-20%",
                3: "More deprived 20-30%",
                4: "More deprived 30-40%",
                5: "More deprived 40-50%",
                6: "Less deprived 40-50%",
                7: "Less deprived 30-40%",
                8: "Less deprived 20-30%",
                9: "Less deprived 10-20%",
                10: "Least deprived 10%",
                -1: "Data missing or out of range",
            },
        ),
    ],
    documentation=ROAD_SAFETY_FEATURES.documentation,
)

ROAD_SAFETY_FULL_SEVERITY_FEATURES = FeatureList(
    features=[
        *[
            copy.deepcopy(f)
            for f in ROAD_SAFETY_FULL_FEATURES.features
            if f.name
            not in ("Sex_of_Driver", "Accident_Severity", "Number_of_Casualties")
        ],
        Feature(
            "Accident_Severity",
            int,
            is_target=True,
            name_extended="accident severity",
            # value_mapping={
            #     1: "Fatal",
            #     2: "Serious",
            #     3: "Slight",
            # },
        ),
        Feature(
            "Sex_of_Driver",
            float,
            value_mapping={
                1: "Male",
                2: "Female",
                3: "Not known",
                -1: "Data missing or out of range",
            },
        ),
    ],
    documentation=ROAD_SAFETY_FEATURES.documentation,
)
