from evaluators.base import BaseEvaluator
from utils.tarski_utils import is_on_optimal_plan


class NextActionEvaluator(BaseEvaluator):
    def get_score(self, ans, doc):

        real_answer = doc["answer"]
        real_answer_yes = [a.lower() for a in real_answer["yes"]]
        real_answer_no = [a.lower() for a in real_answer["no"]]
        real_answer_maybe = [a.lower() for a in real_answer["maybe"]]
        opt = real_answer.get("opt", None)
        for x in ans:
            if x.strip().lower() in real_answer_yes:
                self.scores.append(True)
            elif x.strip().lower() in real_answer_no:
                # applicable, not towards goal
                self.scores.append(False)
            elif x.strip().lower() not in real_answer_maybe:
                # Not applicable
                self.scores.append(False)
            else:                
                # Need to run a planner
                action = x.strip().lower()
                self.scores.append(is_on_optimal_plan(doc["PDDL_domain"].lower(), doc["PDDL_problem"].lower(), action, opt))

        return self.get_avg_score()
