from .applicability import ApplicabilityEvaluator
from .progression import ProgressionEvaluator
from .reachability import ReachabilityEvaluator
from .action_reachability import ActionReachabilityEvaluator
from .validation import ValidationEvaluator
from .landmarks import LandmarksEvaluator
from .next_action import NextActionEvaluator
from .justification import JustificationEvaluator


def get_evaluator(group):
    if group == "applicable_actions_gen":
        return ApplicabilityEvaluator()
    elif group == "progression_gen":
        return ProgressionEvaluator()
    elif group == "validation_gen":
        return ValidationEvaluator()
    elif group == "reachable_atom_gen":
        return ReachabilityEvaluator()
    elif group == "goal_closer_gen":
        return NextActionEvaluator()
    elif group == "action_justification_gen":
        return JustificationEvaluator()
    elif group == "landmarks_gen":
        return LandmarksEvaluator()
    elif group == "reachable_action_gen":
        return ActionReachabilityEvaluator()
    assert True, f"Group {group} not found"
