from evaluators.base import BaseEvaluator

from utils.tarski_utils import get_action_preconditions
from utils.pddl_utils import is_unsolvable_new_goal


class ActionReachabilityEvaluator(BaseEvaluator):
    def get_score(self, ans, doc):

        real_answer = doc["answer"]
        if not real_answer or len(real_answer) == 0:
            # None
            self.add_scores(["none" == x.strip().lower() for x in ans])
        else:
            for x in ans:
                action = x.strip().lower()
                if action in real_answer:
                    self.scores.append(True)
                    continue
                prec = get_action_preconditions(doc["PDDL_domain"].lower(), doc["PDDL_problem"].lower(), action)
                if prec is None:
                    self.scores.append(False)
                else:
                    # Need to run a planner
                    prec = f'(and {" ".join(prec)})'
                    self.scores.append(is_unsolvable_new_goal(doc["PDDL_domain"].lower(), doc["PDDL_problem"].lower(), prec))

        return self.get_avg_score()
