from evaluators.base import BaseEvaluator, fix_action_name
from utils.tarski_utils import is_plan

def is_subsequence(plan, new_plan):
    i = 0
    for a in plan:
        if a == new_plan[i]:
            i+=1
            if len(new_plan) == i:
                # Done
                return True
    return False

def is_subsequence_and_plan(domain, problem, plan, new_plan):
    if len(plan) <= len(new_plan):
        return False
    if not is_subsequence(plan, new_plan):
        return False
    return is_plan(domain, problem, new_plan)


class JustificationEvaluator(BaseEvaluator):
    def get_score(self, ans, doc):
        seq = doc["question"][19:-147]
        seq = seq.replace(") (", ")######(").split("######")
        for x in ans:
            x = [fix_action_name(a) for a in x]
            if len(x) == 0:
                # Wrong answer - never an empty sequence
                self.scores.append(0)
                continue
            self.scores.append(is_subsequence_and_plan(doc["PDDL_domain"].lower(), doc["PDDL_problem"].lower(), seq, x))
        return self.get_avg_score()
