from evaluators.base import BaseEvaluator

class LandmarksEvaluator(BaseEvaluator):
    def get_score(self, ans, doc):
        # Updated version: the questions are generated only for cases where all atoms are either 
        # in state, goal, landmarks, or non-landmarks sets
        real_answer = doc["answer"]
        real_answer_yes = [a.lower() for a in real_answer["yes"]]
        # real_answer_no = [a.lower() for a in real_answer["no"]]

        if "(dummy val1)" in real_answer_yes:
            return 0

        for x in ans:
            if x.strip().lower() in real_answer_yes:
                self.scores.append(True)
            elif x.strip().lower() == "none":
                self.scores.append(len(real_answer_yes) == 0)
            else:
                self.scores.append(False)
                
        return self.get_avg_score()
