from evaluators.base import BaseEvaluator
from utils.pddl_utils import is_unsolvable_new_goal


class ReachabilityEvaluator(BaseEvaluator):
    def get_score(self, ans, doc):
        real_answer = doc["answer"]
        real_answer = [f'({x.strip().lower()})' for x in real_answer]

        if len(real_answer) == 0:
            # None
            self.add_scores(["none" == x.strip().lower() for x in ans])
        else:
            for x in ans:
                if x.strip().lower() in real_answer:
                    self.scores.append(True)
                else:
                    # Need to run a planner
                    atom = x.strip().lower()
                    self.scores.append(is_unsolvable_new_goal(doc["PDDL_domain"].lower(), doc["PDDL_problem"].lower(), atom))

        return self.get_avg_score()
